/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.user;

import com.degoos.wetsponge.user.Spigot13ProfileProperty;
import com.degoos.wetsponge.user.WSGameProfile;
import com.degoos.wetsponge.user.WSProfileProperty;
import com.degoos.wetsponge.util.Validate;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;

public class Spigot13GameProfile
implements WSGameProfile {
    private GameProfile gameProfile;

    public static WSGameProfile of(UUID uniqueId, @Nullable String name) {
        return new Spigot13GameProfile(new GameProfile(uniqueId, name));
    }

    public Spigot13GameProfile(GameProfile gameProfile) {
        this.gameProfile = gameProfile;
    }

    @Override
    public UUID getId() {
        return this.gameProfile.getId();
    }

    @Override
    public Optional<String> getName() {
        return Optional.ofNullable(this.gameProfile.getName());
    }

    @Override
    public Multimap<String, WSProfileProperty> getPropertyMap() {
        LinkedHashMultimap<String, WSProfileProperty> map = LinkedHashMultimap.create();
        this.gameProfile.getProperties().keySet().forEach(key -> this.gameProfile.getProperties().get(key).forEach(prop -> map.put((String)key, new Spigot13ProfileProperty((Property)prop))));
        return map;
    }

    @Override
    public WSGameProfile addProperty(String name, WSProfileProperty property) {
        Validate.notNull(name, "Name cannot be null!");
        Validate.notNull(property, "Property cannot be null!");
        this.gameProfile.getProperties().put((Object)name, (Object)((Spigot13ProfileProperty)property).getHandled());
        return this;
    }

    @Override
    public boolean isFilled() {
        return this.gameProfile.isComplete();
    }

    public GameProfile getHandled() {
        return this.gameProfile;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Spigot13GameProfile that = (Spigot13GameProfile)o;
        return this.gameProfile.equals((Object)that.gameProfile);
    }

    public int hashCode() {
        return this.gameProfile.hashCode();
    }
}

