/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.timing;

import com.degoos.wetsponge.plugin.WSPlugin;
import com.degoos.wetsponge.task.WSTask;
import com.degoos.wetsponge.timing.WSTimingRecorder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class WSTimingsThread {
    private WSTimingRecorder wetSpongeTiming;
    private final long threadId;
    private final String threadName;
    private final Map<WSPlugin, WSTimingRecorder> pluginTimings;
    private WSPlugin assignedPlugin;
    private WSTimingRecorder assignedPluginRecorder;

    public WSTimingsThread(long threadId) {
        this.threadId = threadId;
        this.threadName = null;
        this.wetSpongeTiming = null;
        this.pluginTimings = new ConcurrentHashMap<WSPlugin, WSTimingRecorder>();
        this.assignedPlugin = null;
    }

    public WSTimingsThread(long threadId, String threadName) {
        this.threadId = threadId;
        this.threadName = threadName;
        this.wetSpongeTiming = null;
        this.pluginTimings = new ConcurrentHashMap<WSPlugin, WSTimingRecorder>();
        this.assignedPlugin = null;
    }

    public WSTimingsThread(Thread thread) {
        this.threadId = thread.getId();
        this.threadName = thread.getName();
        this.wetSpongeTiming = null;
        this.pluginTimings = new ConcurrentHashMap<WSPlugin, WSTimingRecorder>();
        this.assignedPlugin = null;
    }

    public void startTiming(String name, StackTraceElement element) {
        if (this.assignedPlugin == null) {
            if (this.wetSpongeTiming == null) {
                this.wetSpongeTiming = new WSTimingRecorder(null);
            }
            this.wetSpongeTiming.startTiming(name, element);
        } else {
            this.assignedPluginRecorder.startTiming(name, element);
        }
    }

    public void startTiming(WSTask task) {
        if (this.assignedPlugin == null) {
            if (this.wetSpongeTiming == null) {
                this.wetSpongeTiming = new WSTimingRecorder(null);
            }
            this.wetSpongeTiming.startTiming(task);
        } else {
            this.assignedPluginRecorder.startTiming(task);
        }
    }

    public void stopTiming() {
        if (this.assignedPlugin == null) {
            if (this.wetSpongeTiming != null) {
                this.wetSpongeTiming.stopTiming();
            }
        } else {
            this.assignedPluginRecorder.stopTiming();
        }
    }

    public void assignPlugin(WSPlugin plugin) {
        if (plugin == null) {
            this.assignedPlugin = null;
            this.assignedPluginRecorder = null;
        } else {
            this.assignedPlugin = plugin;
            this.assignedPluginRecorder = this.getPluginTimings(plugin);
        }
    }

    public WSTimingRecorder getPluginTimings(WSPlugin plugin) {
        if (this.pluginTimings.containsKey(plugin)) {
            return this.pluginTimings.get(plugin);
        }
        WSTimingRecorder recorder = new WSTimingRecorder(plugin);
        this.pluginTimings.put(plugin, recorder);
        return recorder;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public WSPlugin getAssignedPlugin() {
        return this.assignedPlugin;
    }

    public WSTimingRecorder getWetSpongeTiming() {
        return this.wetSpongeTiming;
    }

    public Map<WSPlugin, WSTimingRecorder> getAllPluginTimings() {
        return this.pluginTimings;
    }

    public String getThreadName() {
        return this.threadName == null ? String.valueOf(this.threadId) : this.threadName;
    }

    public void merge(WSTimingsThread thread) {
        thread.pluginTimings.forEach((plugin, recorder) -> {
            if (!this.pluginTimings.containsKey(plugin)) {
                this.pluginTimings.put((WSPlugin)plugin, (WSTimingRecorder)recorder);
            } else {
                this.pluginTimings.get(plugin).merge((WSTimingRecorder)recorder);
            }
        });
    }
}

