/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.timing;

import co.aikar.wetspongeutils.JSONUtil;
import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.command.WSCommandSource;
import com.degoos.wetsponge.config.WetSpongeConfig;
import com.degoos.wetsponge.config.WetSpongeMessages;
import com.degoos.wetsponge.exception.timing.TimingsNotEnabledException;
import com.degoos.wetsponge.plugin.WSPlugin;
import com.degoos.wetsponge.task.WSTask;
import com.degoos.wetsponge.timing.UploadThread;
import com.degoos.wetsponge.timing.WSTimingRecorder;
import com.degoos.wetsponge.timing.WSTimingsThread;
import com.degoos.wetsponge.util.Validate;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jooq.tools.json.JSONValue;

public class WSTimings {
    private UploadThread uploadThread;
    private Map<Long, WSTimingsThread> threads = new ConcurrentHashMap<Long, WSTimingsThread>();
    private boolean enabled;
    private long timingStart = -1L;

    public WSTimings() {
        this.uploadThread = new UploadThread();
        this.uploadThread.start();
        this.setEnabled(WetSpongeConfig.getConfig().getBoolean("startTimingsOnStart"));
    }

    public WSTimingsThread getThread(Thread thread) {
        if (!this.enabled) {
            throw new TimingsNotEnabledException("Timings are not enabled!");
        }
        if (this.threads.containsKey(thread.getId())) {
            return this.threads.get(thread.getId());
        }
        WSTimingsThread timingsThread = new WSTimingsThread(thread);
        this.threads.put(thread.getId(), timingsThread);
        return timingsThread;
    }

    public WSPlugin getAssignedPlugin() {
        return this.getAssignedPlugin(Thread.currentThread());
    }

    public WSPlugin getAssignedPlugin(Thread thread) {
        if (!this.enabled) {
            return null;
        }
        if (this.threads.containsKey(thread.getId())) {
            return this.threads.get(thread.getId()).getAssignedPlugin();
        }
        return null;
    }

    public void assignPluginToThread(Thread thread, WSPlugin plugin) {
        if (!this.enabled) {
            return;
        }
        Validate.notNull(thread, "Thread cannot be null!");
        this.getThread(thread).assignPlugin(plugin);
    }

    public void assignPluginToThread(WSPlugin plugin) {
        if (!this.enabled) {
            return;
        }
        this.getThread(Thread.currentThread()).assignPlugin(plugin);
    }

    public void startTiming(String name) {
        if (!this.enabled) {
            return;
        }
        this.getThread(Thread.currentThread()).startTiming(name, Thread.currentThread().getStackTrace()[2]);
    }

    public void startTiming(WSTask task) {
        if (!this.enabled) {
            return;
        }
        this.getThread(Thread.currentThread()).startTiming(task);
    }

    public void stopTiming() {
        if (!this.enabled) {
            return;
        }
        this.getThread(Thread.currentThread()).stopTiming();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        if (enabled) {
            this.timingStart = System.currentTimeMillis();
        } else {
            this.timingStart = -1L;
            this.threads.clear();
        }
    }

    public void reset() {
        this.timingStart = System.currentTimeMillis();
        this.threads.clear();
    }

    public void report(WSCommandSource source) {
        Map map;
        WetSpongeMessages.getMessage("command.timings.creating", new Object[0]).ifPresent(source::sendMessage);
        Map parent = JSONUtil.createObject(JSONUtil.pair("version", (Object)this.getServerVersion()), JSONUtil.pair("max_players", (Object)WetSponge.getServer().getServerInfo().getMaxPlayers()), JSONUtil.pair("start", (Object)(this.timingStart / 1000L)), JSONUtil.pair("end", (Object)(System.currentTimeMillis() / 1000L)), JSONUtil.pair("sample_time", (Object)((System.currentTimeMillis() - this.timingStart) / 1000L)), JSONUtil.pair("server", (Object)WetSponge.getServer().getServerInfo().getServerName()), JSONUtil.pair("motd", (Object)WetSponge.getServer().getServerInfo().getMotd().getText()), JSONUtil.pair("online_mode", (Object)WetSponge.getServer().getServerInfo().isOnlineMode()), JSONUtil.pair("icon", (Object)WetSponge.getServer().getServerInfo().getBase64ServerIcon()));
        Runtime runtime = Runtime.getRuntime();
        RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
        parent.put("system", JSONUtil.createObject(JSONUtil.pair("name", (Object)System.getProperty("os.name")), JSONUtil.pair("version", (Object)System.getProperty("os.version")), JSONUtil.pair("jvm_version", (Object)System.getProperty("java.version")), JSONUtil.pair("arch", (Object)System.getProperty("os.arch")), JSONUtil.pair("max_memory", (Object)runtime.maxMemory()), JSONUtil.pair("cpu", (Object)runtime.availableProcessors()), JSONUtil.pair("runtime", (Object)ManagementFactory.getRuntimeMXBean().getUptime()), JSONUtil.pair("flags", (Object)String.join((CharSequence)" ", runtimeBean.getInputArguments())), JSONUtil.pair("gc", (Object)JSONUtil.toArrayMapper(ManagementFactory.getGarbageCollectorMXBeans(), input -> JSONUtil.createObject(JSONUtil.pair("name", (Object)input.getName()), JSONUtil.pair("collection_count", (Object)input.getCollectionCount()), JSONUtil.pair("collection_time", (Object)input.getCollectionTime()))))));
        parent.put("plugins", JSONUtil.toArrayMapper(WetSponge.getPluginManager().getPlugins(), plugin -> JSONUtil.createObject(JSONUtil.pair("name", (Object)plugin.getId()), JSONUtil.pair("version", (Object)plugin.getPluginDescription().getVersion()), JSONUtil.pair("description", (Object)plugin.getPluginDescription().getDescription()), JSONUtil.pair("website", (Object)plugin.getPluginDescription().getWebsite()), JSONUtil.pair("authors", plugin.getPluginDescription().getAuthors()))));
        parent.put("base_plugins", JSONUtil.toArrayMapper(WetSponge.getPluginManager().getBasePlugins(), plugin -> JSONUtil.createObject(JSONUtil.pair("name", (Object)plugin.getName()), JSONUtil.pair("version", (Object)plugin.getVersion()), JSONUtil.pair("description", (Object)plugin.getDescription()), JSONUtil.pair("website", (Object)plugin.getUrl()), JSONUtil.pair("authors", plugin.getAuthors()))));
        List timings = JSONUtil.toArray(new Object[0]);
        WSTimingsThread asyncSchedulerThread = null;
        for (WSTimingsThread thread : this.threads.values()) {
            if (thread.getThreadName().startsWith("Craft Scheduler Thread")) {
                if (asyncSchedulerThread == null) {
                    asyncSchedulerThread = new WSTimingsThread(thread.getThreadId(), "Craft Scheduler Thread");
                }
                asyncSchedulerThread.merge(thread);
                continue;
            }
            Map map2 = this.getThreadMap(thread);
            if (map2 == null) continue;
            timings.add(map2);
        }
        if (asyncSchedulerThread != null && (map = this.getThreadMap(asyncSchedulerThread)) != null) {
            timings.add(map);
        }
        parent.put("timings", timings);
        String json = JSONValue.toJSONString(parent);
        this.uploadThread.addRequest(new UploadThread.UploadRequest(source, json));
    }

    private Map getThreadMap(WSTimingsThread thread) {
        if (thread.getAllPluginTimings().isEmpty()) {
            return null;
        }
        Map threadMap = JSONUtil.createObject(new JSONUtil.JSONPair[0]);
        threadMap.put("name", thread.getThreadName());
        List recorders = JSONUtil.toArray(new Object[0]);
        for (Map.Entry<WSPlugin, WSTimingRecorder> recorder : thread.getAllPluginTimings().entrySet()) {
            if (recorder.getValue().getTimings().isEmpty()) continue;
            recorders.add(recorder.getValue().export());
        }
        if (thread.getWetSpongeTiming() != null) {
            recorders.add(thread.getWetSpongeTiming().export());
        }
        threadMap.put("recorders", recorders);
        return threadMap;
    }

    private String getServerVersion() {
        return "WetSponge for " + (Object)((Object)WetSponge.getServerType()) + " (" + (Object)((Object)WetSponge.getVersion()) + ")";
    }
}

