/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.timing;

import co.aikar.wetspongeutils.JSONUtil;
import com.degoos.wetsponge.plugin.WSPlugin;
import com.degoos.wetsponge.task.WSTask;
import com.degoos.wetsponge.timing.WSTiming;
import com.degoos.wetsponge.timing.WSTimingTask;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class WSTimingRecorder {
    private WSPlugin plugin;
    private List<WSTiming> timings;
    private WSTiming currentTiming;

    public WSTimingRecorder(WSPlugin plugin) {
        this.plugin = plugin;
        this.timings = new LinkedList<WSTiming>();
        this.currentTiming = null;
    }

    public WSPlugin getPlugin() {
        return this.plugin;
    }

    public List<WSTiming> getTimings() {
        return this.timings;
    }

    public void startTiming(String name, StackTraceElement element) {
        if (this.currentTiming == null) {
            this.currentTiming = this.timings.stream().filter(target -> target.getName().equals(name)).findAny().orElse(null);
            if (this.currentTiming == null) {
                this.currentTiming = new WSTiming(null, name, element);
                this.timings.add(this.currentTiming);
            }
        } else {
            WSTiming timing = this.currentTiming.getSubTimings().stream().filter(target -> target.getName().equals(name)).findAny().orElse(null);
            if (timing == null) {
                timing = new WSTiming(this.currentTiming, name, element);
                this.currentTiming.getSubTimings().add(timing);
            }
            this.currentTiming = timing;
        }
        this.currentTiming.start();
    }

    public void startTiming(WSTask task) {
        String name = task.getPlugin().getId() + " task " + task.getUniqueId();
        if (this.currentTiming == null) {
            this.currentTiming = this.timings.stream().filter(target -> target.getName().equals(name)).findAny().orElse(null);
            if (this.currentTiming == null) {
                this.currentTiming = new WSTimingTask(null, task);
                this.timings.add(this.currentTiming);
            }
        } else {
            WSTiming timing = this.currentTiming.getSubTimings().stream().filter(target -> target.getName().equals(name)).findAny().orElse(null);
            if (timing == null) {
                timing = new WSTimingTask(this.currentTiming, task);
                this.currentTiming.getSubTimings().add(timing);
            }
            this.currentTiming = timing;
        }
        this.currentTiming.start();
    }

    public void stopTiming() {
        if (this.currentTiming == null) {
            return;
        }
        this.currentTiming.stop();
        this.currentTiming = this.currentTiming.getParent();
    }

    public Map export() {
        Map map = JSONUtil.createObject(new JSONUtil.JSONPair[0]);
        map.put("id", this.plugin == null ? "WetSponge" : this.plugin.getId());
        map.put("timings", JSONUtil.toArrayMapper(this.timings, WSTiming::export));
        return map;
    }

    public void merge(WSTimingRecorder recorder) {
        recorder.timings.forEach(toMerge -> {
            WSTiming timing = this.timings.stream().filter(target -> target.getName().equals(toMerge.getName())).findAny().orElse(null);
            if (timing == null) {
                this.timings.add((WSTiming)toMerge);
            } else {
                timing.merge((WSTiming)toMerge);
            }
        });
    }
}

