/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.timing;

import com.degoos.wetsponge.command.WSCommandSource;
import com.degoos.wetsponge.config.WetSpongeMessages;
import com.degoos.wetsponge.util.HastebinUtils;
import com.degoos.wetsponge.util.InternalLogger;
import com.degoos.wetsponge.util.Validate;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingDeque;

public class UploadThread
extends Thread {
    private Queue<UploadRequest> requests = new LinkedBlockingDeque<UploadRequest>();

    public UploadThread() {
        this.setName("WetSponge timings upload thread");
        this.setPriority(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            Object rawLink;
            UploadRequest request;
            if ((request = this.requests.poll()) != null) {
                WetSpongeMessages.getMessage("command.timings.uploading", new Object[0]).ifPresent(request.source::sendMessage);
                rawLink = HastebinUtils.paste(request.json, false);
                if (rawLink == null) {
                    WetSpongeMessages.getMessage("command.timings.uploadError", new Object[0]).ifPresent(request.source::sendMessage);
                    return;
                }
                String link = "https://timings.degoos.com/#/paste/" + (String)rawLink;
                WetSpongeMessages.getMessage("command.timings.uploaded", "<LINK>", link).ifPresent(request.source::sendMessage);
                continue;
            }
            try {
                rawLink = this;
                synchronized (rawLink) {
                    this.wait();
                    continue;
                }
            }
            catch (InterruptedException e) {
                InternalLogger.printException((Throwable)e, "An error has occurred while WetSponge was waiting an upload request!");
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRequest(UploadRequest request) {
        UploadThread uploadThread = this;
        synchronized (uploadThread) {
            Validate.notNull(request, "Request cannot be null!");
            this.requests.add(request);
            this.notify();
        }
    }

    protected static class UploadRequest {
        private WSCommandSource source;
        private String json;

        public UploadRequest(WSCommandSource source, String json) {
            this.source = source;
            this.json = json;
        }
    }
}

