/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.text;

import com.degoos.wetsponge.bridge.text.BridgeText;
import com.degoos.wetsponge.enums.EnumTextColor;
import com.degoos.wetsponge.enums.EnumTextStyle;
import com.degoos.wetsponge.text.WSTranslatableText;
import com.degoos.wetsponge.text.action.click.WSClickAction;
import com.degoos.wetsponge.text.action.hover.WSHoverAction;
import com.degoos.wetsponge.text.translation.WSTranslation;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public interface WSText {
    public static Builder builder() {
        return BridgeText.builder();
    }

    public static Builder builder(String string) {
        return BridgeText.builder(string);
    }

    public static Builder builder(WSText text) {
        return BridgeText.builder(text);
    }

    public static WSText of(String string) {
        return BridgeText.of(string);
    }

    public static WSText of(String string, EnumTextColor color) {
        return WSText.builder(string).color(color).build();
    }

    public static WSText of(String string, EnumTextColor color, EnumTextStyle style) {
        return WSText.builder(string).color(color).style(Collections.singleton(style)).build();
    }

    public static WSText of(String string, EnumTextColor color, Collection<EnumTextStyle> styles) {
        return WSText.builder(string).color(color).style(styles).build();
    }

    public static WSText of(String string, WSText append) {
        return WSText.builder(string).append(append).build();
    }

    public static WSText of(String string, EnumTextColor color, WSText append) {
        return WSText.builder(string).color(color).append(append).build();
    }

    public static WSText of(String string, EnumTextColor color, WSText append, EnumTextStyle style) {
        return WSText.builder(string).color(color).style(Collections.singleton(style)).append(append).build();
    }

    public static WSText of(String string, EnumTextColor color, WSText append, Collection<EnumTextStyle> styles) {
        return WSText.builder(string).color(color).style(styles).append(append).build();
    }

    public static WSTranslatableText of(WSTranslation translation, Object ... objects) {
        return BridgeText.of(translation, objects);
    }

    public static WSText empty() {
        return WSText.of("");
    }

    public static WSText getByFormattingText(String text) {
        return BridgeText.getByFormattingText(text);
    }

    public String getText();

    public Optional<EnumTextColor> getColor();

    public Collection<EnumTextStyle> getStyles();

    public Collection<? extends WSText> getChildren();

    public Optional<WSClickAction> getClickAction();

    public Optional<WSHoverAction> getHoverAction();

    public boolean contains(String var1);

    public List<WSText> split(String var1);

    public WSText moveChildrenToOneList();

    public WSText replace(String var1, String var2);

    public WSText replace(String var1, WSText var2);

    public String toFormattingText();

    public String toPlain();

    public WSText clone();

    public WSText clone(String var1);

    public WSText cloneSingle();

    public WSText cloneSingle(String var1);

    public Object getHandled();

    default public Builder toBuilder() {
        return WSText.builder(this);
    }

    public static interface Builder {
        public WSText build();

        public Builder color(EnumTextColor var1);

        public Builder style(EnumTextStyle var1);

        public Builder style(Collection<EnumTextStyle> var1);

        public Builder clickAction(WSClickAction var1);

        public Builder hoverAction(WSHoverAction var1);

        public Builder append(WSText ... var1);

        public Builder append(Collection<? extends WSText> var1);

        public Builder newLine();

        public Builder center();

        public Builder stripColors();

        public Builder translateColors();
    }
}

