/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.text;

import com.degoos.wetsponge.enums.EnumTextColor;
import com.degoos.wetsponge.enums.EnumTextStyle;
import com.degoos.wetsponge.resource.centeredmessages.CenteredMessageSender;
import com.degoos.wetsponge.text.SpigotTranslatableText;
import com.degoos.wetsponge.text.WSText;
import com.degoos.wetsponge.text.action.click.SpigotClickAction;
import com.degoos.wetsponge.text.action.click.WSClickAction;
import com.degoos.wetsponge.text.action.hover.SpigotHoverAction;
import com.degoos.wetsponge.text.action.hover.WSHoverAction;
import com.degoos.wetsponge.util.InternalLogger;
import com.degoos.wetsponge.util.reflection.SpigotTextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.TranslatableComponent;

public class SpigotText
implements WSText {
    private BaseComponent text;

    public static SpigotText of(BaseComponent component) {
        if (component instanceof TranslatableComponent) {
            return new SpigotTranslatableText((TranslatableComponent)component);
        }
        return new SpigotText(component);
    }

    protected SpigotText(BaseComponent text) {
        this.text = text;
    }

    public SpigotText(String string) {
        this.text = new TextComponent(string);
    }

    public static SpigotText getByFormattingText(String text) {
        try {
            return SpigotText.of(SpigotText.concentrate(SpigotTextUtils.fromLegacyText(text)));
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was creating a text by a formatted text! (Text: " + text + ")");
            return new SpigotText("");
        }
    }

    @Override
    public String getText() {
        if (this.text instanceof TranslatableComponent) {
            return ((TranslatableComponent)this.text).getTranslate();
        }
        if (this.text instanceof TextComponent) {
            return ((TextComponent)this.text).getText();
        }
        return this.text.toString();
    }

    private static BaseComponent concentrate(BaseComponent[] texts) {
        if (texts.length == 1) {
            return texts[0];
        }
        return new TextComponent(texts);
    }

    @Override
    public Optional<EnumTextColor> getColor() {
        return this.text.getColorRaw() == null ? Optional.empty() : EnumTextColor.getByName(this.text.getColorRaw().getName());
    }

    @Override
    public Collection<EnumTextStyle> getStyles() {
        ArrayList<EnumTextStyle> styles = new ArrayList<EnumTextStyle>();
        if (this.text.isBold()) {
            styles.add(EnumTextStyle.BOLD);
        }
        if (this.text.isItalic()) {
            styles.add(EnumTextStyle.ITALIC);
        }
        if (this.text.isObfuscated()) {
            styles.add(EnumTextStyle.OBFUSCATED);
        }
        if (this.text.isStrikethrough()) {
            styles.add(EnumTextStyle.STRIKETHROUGH);
        }
        if (this.text.isUnderlined()) {
            styles.add(EnumTextStyle.UNDERLINE);
        }
        return styles;
    }

    @Override
    public Collection<? extends WSText> getChildren() {
        if (this.text.getExtra() == null) {
            return new ArrayList();
        }
        return this.text.getExtra().stream().map(SpigotText::of).collect(Collectors.toList());
    }

    @Override
    public Optional<WSClickAction> getClickAction() {
        return Optional.ofNullable(this.getHandled().getClickEvent()).map(SpigotClickAction::of);
    }

    @Override
    public Optional<WSHoverAction> getHoverAction() {
        return Optional.ofNullable(this.getHandled().getHoverEvent()).map(SpigotHoverAction::of);
    }

    @Override
    public boolean contains(String sequence) {
        if (this.getText().contains(sequence)) {
            return true;
        }
        for (WSText wSText : this.getChildren()) {
            if (!wSText.contains(sequence)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<WSText> split(String regex) {
        ArrayList<WSText> list = new ArrayList<WSText>();
        boolean endsWithRegex = false;
        WSText clone = this.moveChildrenToOneList();
        WSText parent = clone.cloneSingle();
        if (parent.getText().contains(regex)) {
            endsWithRegex = parent.getText().endsWith(regex);
            String[] strings = parent.getText().split(regex);
            parent = clone.cloneSingle(strings.length > 0 ? strings[0] : "");
            if (strings.length > 1) {
                for (int i = 1; i < strings.length; ++i) {
                    list.add(parent);
                    parent = clone.cloneSingle(strings[i]);
                }
            }
        }
        if (endsWithRegex) {
            list.add(parent);
        }
        WSText.Builder lastBuilder = endsWithRegex ? null : parent.toBuilder();
        Collection<? extends WSText> children = clone.getChildren();
        for (WSText wSText : children) {
            if (wSText.getText().contains(regex)) {
                String[] strings = wSText.getText().split(regex);
                if (strings.length <= 1) {
                    WSText.Builder childBuilder = this.applyParent(wSText, parent, strings.length == 0 ? "" : strings[0]);
                    if (endsWithRegex) {
                        lastBuilder = childBuilder;
                    } else {
                        lastBuilder.append(childBuilder.build());
                    }
                    if (!(endsWithRegex = wSText.getText().endsWith(regex))) continue;
                    list.add(lastBuilder.build());
                    continue;
                }
                if (endsWithRegex) {
                    lastBuilder = wSText.cloneSingle(strings[0]).toBuilder();
                } else {
                    lastBuilder.append(wSText.cloneSingle(strings[0]));
                }
                endsWithRegex = wSText.getText().endsWith(regex);
                for (int i = 1; i < strings.length; ++i) {
                    list.add(lastBuilder.build());
                    WSText.Builder childBuilder = this.applyParent(wSText, parent, strings[1]);
                    if (!wSText.getColor().isPresent()) {
                        Collection<EnumTextStyle> styles = wSText.getStyles();
                        styles.addAll(parent.getStyles());
                        childBuilder.style(styles);
                    }
                    if (!wSText.getColor().isPresent() && parent.getColor().isPresent()) {
                        childBuilder.color(parent.getColor().get());
                    }
                    if (!wSText.getHoverAction().isPresent() && parent.getHoverAction().isPresent()) {
                        childBuilder.hoverAction(parent.getHoverAction().get());
                    }
                    if (!wSText.getClickAction().isPresent() && parent.getClickAction().isPresent()) {
                        childBuilder.clickAction(parent.getClickAction().get());
                    }
                    lastBuilder = childBuilder;
                }
                if (!endsWithRegex) continue;
                list.add(lastBuilder.build());
                continue;
            }
            WSText.Builder childBuilder = this.applyParent(wSText, parent, wSText.getText());
            if (endsWithRegex) {
                lastBuilder = childBuilder;
            } else {
                lastBuilder.append(childBuilder.build());
            }
            endsWithRegex = false;
        }
        if (!endsWithRegex) {
            list.add(lastBuilder.build());
        }
        return list;
    }

    private WSText.Builder applyParent(WSText child, WSText parent, String name) {
        WSText.Builder childBuilder = child.cloneSingle(name).toBuilder();
        if (!child.getColor().isPresent()) {
            Collection<EnumTextStyle> styles = child.getStyles();
            styles.addAll(parent.getStyles());
            childBuilder.style(styles);
        }
        if (!child.getColor().isPresent() && parent.getColor().isPresent()) {
            childBuilder.color(parent.getColor().get());
        }
        if (!child.getHoverAction().isPresent() && parent.getHoverAction().isPresent()) {
            childBuilder.hoverAction(parent.getHoverAction().get());
        }
        if (!child.getClickAction().isPresent() && parent.getClickAction().isPresent()) {
            childBuilder.clickAction(parent.getClickAction().get());
        }
        return childBuilder;
    }

    @Override
    public WSText moveChildrenToOneList() {
        WSText.Builder builder = this.cloneSingle().toBuilder();
        this.getChildren().forEach(child -> {
            builder.append(child.cloneSingle());
            child.getChildren().forEach(childChild -> this.append(builder, (WSText)childChild, (WSText)child));
        });
        return builder.build();
    }

    private void append(WSText.Builder builder, WSText child, WSText parent) {
        WSText.Builder childBuilder = child.cloneSingle().toBuilder();
        if (!child.getColor().isPresent()) {
            Collection<EnumTextStyle> styles = child.getStyles();
            styles.addAll(parent.getStyles());
            childBuilder.style(styles);
        }
        if (!child.getColor().isPresent() && parent.getColor().isPresent()) {
            childBuilder.color(parent.getColor().get());
        }
        if (!child.getHoverAction().isPresent() && parent.getHoverAction().isPresent()) {
            childBuilder.hoverAction(parent.getHoverAction().get());
        }
        if (!child.getClickAction().isPresent() && parent.getClickAction().isPresent()) {
            childBuilder.clickAction(parent.getClickAction().get());
        }
        WSText newChild = childBuilder.build();
        builder.append(newChild);
        child.getChildren().forEach(childChild -> this.append(builder, (WSText)childChild, newChild));
    }

    @Override
    public WSText replace(String toReplace, String replacement) {
        WSText.Builder clone = this.cloneSingle(this.getText().replace(toReplace, replacement)).toBuilder();
        this.getChildren().forEach(child -> clone.append(child.replace(toReplace, replacement)));
        return clone.build();
    }

    @Override
    public WSText replace(String toReplace, WSText replacement) {
        if (!this.contains(toReplace)) {
            return this;
        }
        boolean endsWithToReplace = this.toPlain().endsWith(toReplace);
        List<WSText> split = this.split(toReplace);
        WSText.Builder firstBuilder = split.get(0).toBuilder();
        firstBuilder.append(replacement);
        for (int i = 1; i < split.size() - (endsWithToReplace ? 0 : 1); ++i) {
            WSText text = split.get(i);
            WSText.Builder builder = text.toBuilder();
            builder.append(this.applyParent(replacement, text, replacement.getText()).build());
            firstBuilder.append(builder.build());
        }
        return firstBuilder.build();
    }

    @Override
    public String toFormattingText() {
        StringBuilder builder = new StringBuilder();
        if (this.text.getColorRaw() != null) {
            builder.append(this.text.getColorRaw().toString());
        }
        this.getStyles().forEach(style -> builder.append(style.toString()));
        if (this.text instanceof TranslatableComponent) {
            builder.append(((TranslatableComponent)this.text).getTranslate());
        }
        if (this.text instanceof TextComponent) {
            builder.append(((TextComponent)this.text).getText());
        }
        this.getChildren().forEach(child -> builder.append(child.toFormattingText()));
        return builder.toString();
    }

    @Override
    public String toPlain() {
        return this.text.toPlainText();
    }

    @Override
    public WSText clone() {
        return this.clone(this.getText());
    }

    @Override
    public WSText clone(String string) {
        WSText.Builder text = WSText.builder(string);
        this.getColor().ifPresent(text::color);
        text.style(this.getStyles());
        this.getHoverAction().ifPresent(text::hoverAction);
        this.getClickAction().ifPresent(text::clickAction);
        this.getChildren().forEach(child -> text.append(child.clone()));
        return text.build();
    }

    @Override
    public WSText cloneSingle() {
        return this.cloneSingle(this.getText());
    }

    @Override
    public WSText cloneSingle(String string) {
        WSText.Builder text = WSText.builder(string);
        this.getColor().ifPresent(text::color);
        text.style(this.getStyles());
        this.getHoverAction().ifPresent(text::hoverAction);
        this.getClickAction().ifPresent(text::clickAction);
        return text.build();
    }

    public BaseComponent getHandled() {
        return this.text;
    }

    public String toString() {
        return this.text.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpigotText that = (SpigotText)o;
        return that.toFormattingText().equals(this.toFormattingText());
    }

    public int hashCode() {
        return this.toFormattingText().hashCode();
    }

    public static class Builder
    implements WSText.Builder {
        private BaseComponent baseComponent;

        public Builder() {
            this.baseComponent = new TextComponent();
        }

        public Builder(String string) {
            this.baseComponent = new TextComponent(string);
        }

        public Builder(WSText text) {
            this.baseComponent = ((SpigotText)text).getHandled().duplicate();
        }

        @Override
        public WSText build() {
            return SpigotText.of(this.baseComponent);
        }

        @Override
        public WSText.Builder color(EnumTextColor color) {
            this.baseComponent.setColor(ChatColor.getByChar((char)color.getId()));
            return this;
        }

        @Override
        public WSText.Builder style(EnumTextStyle style) {
            return this.style(Collections.singleton(style));
        }

        @Override
        public WSText.Builder style(Collection<EnumTextStyle> styles) {
            for (EnumTextStyle textStyle : styles) {
                switch (textStyle) {
                    case OBFUSCATED: {
                        this.baseComponent.setObfuscated(Boolean.valueOf(true));
                        break;
                    }
                    case BOLD: {
                        this.baseComponent.setBold(Boolean.valueOf(true));
                        break;
                    }
                    case STRIKETHROUGH: {
                        this.baseComponent.setStrikethrough(Boolean.valueOf(true));
                        break;
                    }
                    case UNDERLINE: {
                        this.baseComponent.setUnderlined(Boolean.valueOf(true));
                        break;
                    }
                    case ITALIC: {
                        this.baseComponent.setItalic(Boolean.valueOf(true));
                        break;
                    }
                    case RESET: {
                        this.baseComponent.setObfuscated(Boolean.valueOf(false));
                        this.baseComponent.setBold(Boolean.valueOf(false));
                        this.baseComponent.setStrikethrough(Boolean.valueOf(false));
                        this.baseComponent.setUnderlined(Boolean.valueOf(false));
                        this.baseComponent.setItalic(Boolean.valueOf(false));
                    }
                }
            }
            return this;
        }

        @Override
        public WSText.Builder clickAction(WSClickAction action) {
            if (action == null) {
                this.baseComponent.setClickEvent(null);
            }
            this.baseComponent.setClickEvent(((SpigotClickAction)action).getHandled());
            return this;
        }

        @Override
        public WSText.Builder hoverAction(WSHoverAction action) {
            if (action == null) {
                this.baseComponent.setHoverEvent(null);
            } else {
                this.baseComponent.setHoverEvent(((SpigotHoverAction)action).getHandled());
            }
            return this;
        }

        @Override
        public WSText.Builder append(WSText ... children) {
            for (WSText text : children) {
                this.baseComponent.addExtra(((SpigotText)text).getHandled());
            }
            return this;
        }

        @Override
        public WSText.Builder append(Collection<? extends WSText> children) {
            children.forEach(text -> this.baseComponent.addExtra(((SpigotText)text).getHandled()));
            return this;
        }

        @Override
        public WSText.Builder newLine() {
            this.baseComponent.addExtra("\n");
            return this;
        }

        @Override
        public WSText.Builder center() {
            this.baseComponent = new TextComponent(CenteredMessageSender.getCenteredMessage(SpigotText.of(this.baseComponent).toFormattingText()));
            return this;
        }

        @Override
        public WSText.Builder stripColors() {
            this.stripColor(this.baseComponent);
            return this;
        }

        private void stripColor(BaseComponent baseComponent) {
            baseComponent.setColor(null);
            baseComponent.getExtra().forEach(this::stripColor);
        }

        @Override
        public WSText.Builder translateColors() {
            this.baseComponent = new TextComponent(TextComponent.fromLegacyText((String)SpigotText.of(this.baseComponent).toFormattingText().replace('&', '\u00a7')));
            return this;
        }
    }
}

