/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.skin;

import com.degoos.wetsponge.skin.JSkinData;
import com.degoos.wetsponge.skin.WSSkinTexture;
import com.degoos.wetsponge.user.WSGameProfile;
import com.degoos.wetsponge.util.Validate;
import java.util.UUID;

public class WSSkinData {
    private UUID uniqueId;
    private WSSkinTexture texture;

    public WSSkinData(UUID uniqueId, WSSkinTexture texture) {
        Validate.notNull(uniqueId, "Unique id cannot be null!");
        Validate.notNull(texture, "Texture cannot be null!");
        this.uniqueId = uniqueId;
        this.texture = texture;
    }

    WSSkinData(JSkinData skinData) {
        this.uniqueId = skinData.uuid;
        this.texture = new WSSkinTexture(skinData.texture);
    }

    public UUID getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(UUID uniqueId) {
        Validate.notNull(uniqueId, "Unique id cannot be null!");
        this.uniqueId = uniqueId;
    }

    public WSSkinTexture getTexture() {
        return this.texture;
    }

    public void setTexture(WSSkinTexture texture) {
        Validate.notNull(texture, "Texture cannot be null!");
        this.texture = texture;
    }

    public WSGameProfile toGameProfile() {
        return WSGameProfile.of(this.uniqueId).addProperty(this.texture.toProperty());
    }

    public WSGameProfile toGameProfile(String name) {
        return WSGameProfile.of(this.uniqueId, name).addProperty(this.texture.toProperty());
    }

    public WSSkinData clone() {
        return new WSSkinData(this.uniqueId, this.texture.clone());
    }
}

