/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.skin;

import com.degoos.wetsponge.skin.JMineskin;
import com.degoos.wetsponge.skin.WSMineskin;
import com.degoos.wetsponge.skin.WSMineskinCallback;
import com.degoos.wetsponge.skin.WSMineskinOptions;
import com.degoos.wetsponge.util.Validate;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileInputStream;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.jsoup.Connection;
import org.jsoup.Jsoup;

public class WSMineskinClient {
    public static final String ID_FORMAT = "http://api.mineskin.org/get/id/%s";
    public static final String URL_FORMAT = "http://api.mineskin.org/generate/url?url=%s&%s";
    public static final String UPLOAD_FORMAT = "http://api.mineskin.org/generate/upload?%s";
    public static final String USER_FORMAT = "http://api.mineskin.org/generate/user/%s?%s";
    private Executor executor;
    private String userAgent;
    private JsonParser jsonParser;
    private Gson gson;
    private long nextRequest;

    public WSMineskinClient() {
        this(Executors.newSingleThreadExecutor(), "MineSkin-JavaClient");
    }

    public WSMineskinClient(Executor executor) {
        this(executor, "MineSkin-JavaClient");
    }

    public WSMineskinClient(String userAgent) {
        this(Executors.newSingleThreadExecutor(), userAgent);
    }

    public WSMineskinClient(Executor executor, String userAgent) {
        Validate.notNull(executor, "Executor cannot be null!");
        Validate.notNull(userAgent, "User agent cannot be null!");
        this.executor = executor;
        this.userAgent = userAgent;
        this.gson = new Gson();
        this.jsonParser = new JsonParser();
    }

    public long getNextRequest() {
        return this.nextRequest;
    }

    public void getMineskin(int skinId, WSMineskinCallback callback) {
        Validate.notNull(callback, "Callback cannot be null!");
        this.executor.execute(() -> {
            try {
                Connection connection = Jsoup.connect(String.format(ID_FORMAT, skinId)).userAgent(this.userAgent).method(Connection.Method.GET).ignoreContentType(true).ignoreContentType(true).timeout(10000);
                this.onResponse(connection.execute().body(), callback);
            }
            catch (Exception ex) {
                callback.onCommonException(ex);
            }
            catch (Throwable throwable) {
                callback.onThrowable(throwable);
            }
        });
    }

    public void createSkinFromURL(String url, WSMineskinOptions options, WSMineskinCallback callback) {
        Validate.notNull(url, "URL cannot be null!");
        Validate.notNull(options, "Options cannot be null!");
        Validate.notNull(callback, "Callback cannot be null!");
        this.executor.execute(() -> {
            try {
                if (System.currentTimeMillis() < this.nextRequest) {
                    long delay = this.nextRequest - System.currentTimeMillis();
                    callback.onWaiting(delay);
                    Thread.sleep(delay + 1000L);
                }
                callback.onUploading();
                Connection connection = Jsoup.connect(String.format(URL_FORMAT, url, options.toUrlParam())).userAgent(this.userAgent).method(Connection.Method.POST).ignoreContentType(true).ignoreHttpErrors(true).timeout(10000);
                this.onResponse(connection.execute().body(), callback);
            }
            catch (Exception e) {
                callback.onCommonException(e);
            }
            catch (Throwable throwable) {
                callback.onThrowable(throwable);
            }
        });
    }

    public void createSkinFromFile(File file, WSMineskinOptions options, WSMineskinCallback callback) {
        Validate.notNull(file, "File cannot be null!");
        Validate.notNull(options, "Options cannot be null!");
        Validate.notNull(callback, "Callback cannot be null!");
        this.executor.execute(() -> {
            try {
                if (System.currentTimeMillis() < this.nextRequest) {
                    long delay = this.nextRequest - System.currentTimeMillis();
                    callback.onWaiting(delay);
                    Thread.sleep(delay + 1000L);
                }
                callback.onUploading();
                Connection connection = Jsoup.connect(String.format(UPLOAD_FORMAT, options.toUrlParam())).userAgent(this.userAgent).method(Connection.Method.POST).data("file", file.getName(), new FileInputStream(file)).ignoreContentType(true).ignoreHttpErrors(true).timeout(10000);
                this.onResponse(connection.execute().body(), callback);
            }
            catch (Exception e) {
                callback.onCommonException(e);
            }
            catch (Throwable throwable) {
                callback.onThrowable(throwable);
            }
        });
    }

    public void createSkinFromUser(UUID userUniqueId, WSMineskinOptions options, WSMineskinCallback callback) {
        Validate.notNull(userUniqueId, "User unique id cannot be null!");
        Validate.notNull(options, "Options cannot be null!");
        Validate.notNull(callback, "Callback cannot be null!");
        this.executor.execute(() -> {
            try {
                if (System.currentTimeMillis() < this.nextRequest) {
                    long delay = this.nextRequest - System.currentTimeMillis();
                    callback.onWaiting(delay);
                    Thread.sleep(delay + 1000L);
                }
                callback.onUploading();
                Connection connection = Jsoup.connect(String.format(USER_FORMAT, userUniqueId.toString(), options.toUrlParam())).userAgent(this.userAgent).method(Connection.Method.GET).ignoreContentType(true).ignoreHttpErrors(true).timeout(10000);
                this.onResponse(connection.execute().body(), callback);
            }
            catch (Exception e) {
                callback.onCommonException(e);
            }
            catch (Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        });
    }

    private void onResponse(String body, WSMineskinCallback callback) {
        try {
            JsonObject jsonObject = this.jsonParser.parse(body).getAsJsonObject();
            if (jsonObject.has("error")) {
                callback.onError(jsonObject.get("error").getAsString());
                return;
            }
            JMineskin jMineskin = (JMineskin)this.gson.fromJson((JsonElement)jsonObject, JMineskin.class);
            WSMineskin mineskin = new WSMineskin(jMineskin);
            this.nextRequest = System.currentTimeMillis() + (long)(jMineskin.nextRequest * 1000.0);
            callback.onDone(mineskin);
        }
        catch (JsonParseException ex) {
            callback.onParseException((Exception)((Object)ex), body);
        }
        catch (Exception ex) {
            callback.onCommonException(ex);
        }
        catch (Throwable throwable) {
            callback.onThrowable(throwable);
        }
    }
}

