/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.scoreboard;

import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.entity.living.player.WSPlayer;
import com.degoos.wetsponge.enums.EnumCriteria;
import com.degoos.wetsponge.enums.EnumServerType;
import com.degoos.wetsponge.enums.EnumTextColor;
import com.degoos.wetsponge.scoreboard.WSObjective;
import com.degoos.wetsponge.scoreboard.WSObjectiveReplacement;
import com.degoos.wetsponge.scoreboard.WSScore;
import com.degoos.wetsponge.scoreboard.WSScoreboard;
import com.degoos.wetsponge.text.WSText;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class WSUpdatableObjective
implements WSObjective {
    private WSText title;
    private Set<WSObjectiveReplacement> titleReplacements;
    private Map<Integer, WSText> defaultTexts;
    private Map<WSObjectiveReplacement, Set<Integer>> replacements;
    private WSPlayer player;
    private WSObjective objective;

    public WSUpdatableObjective(WSPlayer player, WSScoreboard scoreboard, String name, WSText title, List<WSText> texts, WSObjectiveReplacement ... replacements) {
        HashMap<Integer, WSText> textsMap = new HashMap<Integer, WSText>();
        int i = texts.size();
        for (WSText text : texts) {
            textsMap.put(i, text);
            --i;
        }
        this.objective = scoreboard.getOrCreateObjective(name, WSText.empty(), EnumCriteria.DUMMY);
        this.player = player;
        this.title = title;
        this.defaultTexts = textsMap;
        this.configureReplacements(replacements);
        this.insertIntoObjective();
    }

    public WSUpdatableObjective(WSPlayer player, WSScoreboard scoreboard, String name, WSText title, Map<Integer, WSText> texts, WSObjectiveReplacement ... replacements) {
        this.objective = scoreboard.getOrCreateObjective(name, WSText.empty(), EnumCriteria.DUMMY);
        this.player = player;
        this.title = title;
        this.defaultTexts = texts;
        this.configureReplacements(replacements);
        this.insertIntoObjective();
    }

    private void configureReplacements(WSObjectiveReplacement ... replacements) {
        this.replacements = new HashMap<WSObjectiveReplacement, Set<Integer>>();
        this.titleReplacements = new HashSet<WSObjectiveReplacement>();
        for (WSObjectiveReplacement replacement : replacements) {
            HashSet<Integer> set = new HashSet<Integer>();
            for (Map.Entry<Integer, WSText> text : this.defaultTexts.entrySet()) {
                if (!text.getValue().contains(replacement.getKey())) continue;
                set.add(text.getKey());
            }
            this.replacements.put(replacement, set);
            if (!this.title.contains(replacement.getKey())) continue;
            this.titleReplacements.add(replacement);
        }
    }

    private void insertIntoObjective() {
        WSText title = this.title;
        for (WSObjectiveReplacement replacement : this.titleReplacements) {
            title = replacement.apply(title, this.player);
        }
        this.setDisplayName(title);
        this.defaultTexts.forEach(this::insertIntoObjective);
    }

    private void insertIntoObjective(Integer index) {
        if (!this.defaultTexts.containsKey(index)) {
            return;
        }
        this.insertIntoObjective(index, this.defaultTexts.get(index));
    }

    private void insertIntoObjective(Integer index, WSText text) {
        if (WetSponge.getServerType() == EnumServerType.SPIGOT || WetSponge.getServerType() == EnumServerType.PAPER_SPIGOT) {
            for (Map.Entry<WSObjectiveReplacement, Set<Integer>> entry : this.replacements.entrySet()) {
                if (!entry.getValue().contains(index)) continue;
                text = entry.getKey().apply(text, this.player);
            }
            WSText newText = text.toBuilder().append(WSText.of("", EnumTextColor.getByChar(String.valueOf(index % 10).charAt(0)).orElse(EnumTextColor.WHITE))).append(WSText.of("", EnumTextColor.getByChar(String.valueOf(index % 3).charAt(0)).orElse(EnumTextColor.WHITE))).build();
            if (text.toFormattingText().equals(newText.toFormattingText())) {
                return;
            }
            this.removeAllScoresWithScore(index);
            this.getOrCreateScore(newText).setScore(index);
            return;
        }
        for (Map.Entry<WSObjectiveReplacement, Set<Integer>> entry : this.replacements.entrySet()) {
            if (!entry.getValue().contains(index)) continue;
            text = entry.getKey().apply(text, this.player);
        }
        WSText newText = text.toBuilder().append(WSText.of("", EnumTextColor.getByChar(String.valueOf(index % 10).charAt(0)).orElse(EnumTextColor.WHITE))).append(WSText.of("", EnumTextColor.getByChar(String.valueOf(index % 3).charAt(0)).orElse(EnumTextColor.WHITE))).build();
        Optional<WSScore> score = this.getScore(text);
        if (score.isPresent()) {
            score.get().setScore(index);
        } else {
            this.removeAllScoresWithScore(index);
            this.getOrCreateScore(newText).setScore(index);
        }
    }

    public void update(String replacementKey) {
        if (this.titleReplacements.stream().anyMatch(target -> target.getKey().equals(replacementKey))) {
            WSText title = this.title;
            for (WSObjectiveReplacement replacement : this.titleReplacements) {
                title = replacement.apply(title, this.player);
            }
            this.setDisplayName(title);
        }
        this.replacements.entrySet().stream().filter(entry -> ((WSObjectiveReplacement)entry.getKey()).getKey().equals(replacementKey)).findAny().ifPresent(entry -> ((Set)entry.getValue()).forEach(this::insertIntoObjective));
    }

    public WSPlayer getPlayer() {
        return this.player;
    }

    @Override
    public String getName() {
        return this.objective.getName();
    }

    @Override
    public WSText getDisplayName() {
        return this.objective.getDisplayName();
    }

    @Override
    public void setDisplayName(WSText text) {
        this.objective.setDisplayName(text);
    }

    @Override
    public EnumCriteria getCriteria() {
        return this.objective.getCriteria();
    }

    @Override
    public Map<WSText, WSScore> getScores() {
        return this.objective.getScores();
    }

    @Override
    public boolean hasScore(WSText name) {
        return this.objective.hasScore(name);
    }

    @Override
    public WSScore getOrCreateScore(WSText name) {
        return this.objective.getOrCreateScore(name);
    }

    @Override
    public boolean removeScore(WSText name) {
        return this.objective.removeScore(name);
    }

    @Override
    public boolean removeScore(WSScore score) {
        return this.objective.removeScore(score);
    }

    @Override
    public void removeAllScoresWithScore(int score) {
        this.objective.removeAllScoresWithScore(score);
    }

    @Override
    public Optional<WSScoreboard> getScoreboard() {
        return this.objective.getScoreboard();
    }

    public WSObjective getObjective() {
        return this.objective;
    }

    @Override
    public Object getHandled() {
        return this.objective.getHandled();
    }
}

