/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.scoreboard;

import com.degoos.wetsponge.enums.EnumCriteria;
import com.degoos.wetsponge.enums.EnumDisplaySlot;
import com.degoos.wetsponge.scoreboard.SpongeObjective;
import com.degoos.wetsponge.scoreboard.SpongeTeam;
import com.degoos.wetsponge.scoreboard.WSObjective;
import com.degoos.wetsponge.scoreboard.WSScoreboard;
import com.degoos.wetsponge.scoreboard.WSTeam;
import com.degoos.wetsponge.scoreboard.WSUpdatableObjective;
import com.degoos.wetsponge.text.SpongeText;
import com.degoos.wetsponge.text.WSText;
import com.degoos.wetsponge.util.Validate;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.scoreboard.Scoreboard;
import org.spongepowered.api.scoreboard.Team;
import org.spongepowered.api.scoreboard.critieria.Criteria;
import org.spongepowered.api.scoreboard.critieria.Criterion;
import org.spongepowered.api.scoreboard.displayslot.DisplaySlot;
import org.spongepowered.api.scoreboard.displayslot.DisplaySlots;
import org.spongepowered.api.scoreboard.objective.Objective;
import org.spongepowered.api.text.Text;

public class SpongeScoreboard
implements WSScoreboard {
    private Scoreboard scoreboard;

    public SpongeScoreboard(Scoreboard scoreboard) {
        Validate.notNull(scoreboard, "Scoreboard cannot be null!");
        this.scoreboard = scoreboard;
    }

    @Override
    public Optional<WSObjective> getObjective(String name) {
        Validate.notNull(name, "Name cannot be null!");
        return this.scoreboard.getObjective(name).map(SpongeObjective::new);
    }

    @Override
    public Optional<WSObjective> getObjective(EnumDisplaySlot displaySlot) {
        Validate.notNull((Object)displaySlot, "DisplaySlot cannot be null!");
        return this.scoreboard.getObjective(Sponge.getRegistry().getType(DisplaySlot.class, displaySlot.getSpongeName()).orElse(DisplaySlots.SIDEBAR)).map(SpongeObjective::new);
    }

    @Override
    public WSObjective getOrCreateObjective(String name, @Nullable WSText displayName, EnumCriteria criteria) {
        Validate.notNull((Object)criteria, "Criteria cannot be null!");
        Validate.notNull(name, "Name cannot be null!");
        Optional<WSObjective> optional = this.getObjective(name);
        if (optional.isPresent()) {
            return optional.get();
        }
        Objective objective = Objective.builder().name(name).displayName((Text)(displayName == null ? Text.of((String)name) : ((SpongeText)displayName).getHandled())).criterion(Sponge.getRegistry().getType(Criterion.class, criteria.getSpongeName()).orElse(Criteria.DUMMY)).build();
        this.scoreboard.addObjective(objective);
        return new SpongeObjective(objective);
    }

    @Override
    public void updateDisplaySlot(@Nullable WSObjective objective, EnumDisplaySlot displaySlot) {
        Validate.notNull((Object)displaySlot, "DisplaySlot cannot be null!");
        if (objective == null) {
            this.scoreboard.clearSlot(Sponge.getRegistry().getType(DisplaySlot.class, displaySlot.getSpongeName()).orElse(DisplaySlots.SIDEBAR));
        } else {
            if (objective instanceof WSUpdatableObjective) {
                objective = ((WSUpdatableObjective)objective).getObjective();
            }
            this.scoreboard.updateDisplaySlot(((SpongeObjective)objective).getHandled(), Sponge.getRegistry().getType(DisplaySlot.class, displaySlot.getSpongeName()).orElse(DisplaySlots.SIDEBAR));
        }
    }

    @Override
    public Set<WSObjective> getObjectives() {
        return this.scoreboard.getObjectives().stream().map(SpongeObjective::new).collect(Collectors.toSet());
    }

    @Override
    public void removeObjective(WSObjective objective) {
        Validate.notNull(objective, "Objective cannot be null!");
        if (objective instanceof WSUpdatableObjective) {
            objective = ((WSUpdatableObjective)objective).getObjective();
        }
        this.scoreboard.removeObjective(((SpongeObjective)objective).getHandled());
    }

    @Override
    public void clearObjectives() {
        new HashSet(this.scoreboard.getObjectives()).forEach(arg_0 -> ((Scoreboard)this.scoreboard).removeObjective(arg_0));
    }

    @Override
    public Optional<WSTeam> getTeam(String name) {
        Validate.notNull(name, "Name cannot be null!");
        return this.scoreboard.getTeam(name).map(SpongeTeam::new);
    }

    @Override
    public boolean hasTeam(String name) {
        Validate.notNull(name, "Name cannot be null!");
        return this.getTeam(name).isPresent();
    }

    @Override
    public WSTeam getOrCreateTeam(String name) {
        Validate.notNull(name, "Name cannot be null!");
        Optional<WSTeam> optional = this.getTeam(name);
        if (optional.isPresent()) {
            return optional.get();
        }
        Team team = Team.builder().name(name).build();
        this.scoreboard.registerTeam(team);
        return new SpongeTeam(team);
    }

    @Override
    public Set<WSTeam> getTeams() {
        return this.scoreboard.getTeams().stream().map(SpongeTeam::new).collect(Collectors.toSet());
    }

    @Override
    public Optional<WSTeam> getMemberTeam(WSText member) {
        Validate.notNull(member, "Member cannot be null!");
        return this.scoreboard.getMemberTeam(((SpongeText)member).getHandled()).map(SpongeTeam::new);
    }

    @Override
    public boolean unregisterTeam(WSTeam team) {
        Validate.notNull(team, "Team cannot be null!");
        return team.unregister();
    }

    @Override
    public void unregisterAllTeams() {
        this.getTeams().forEach(WSTeam::unregister);
    }

    public Scoreboard getHandled() {
        return this.scoreboard;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpongeScoreboard that = (SpongeScoreboard)o;
        return this.scoreboard.equals(that.scoreboard);
    }

    public int hashCode() {
        return this.scoreboard.hashCode();
    }
}

