/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.scoreboard;

import com.degoos.wetsponge.enums.EnumCollisionRule;
import com.degoos.wetsponge.enums.EnumVisibility;
import com.degoos.wetsponge.scoreboard.SpigotScoreboard;
import com.degoos.wetsponge.scoreboard.WSScoreboard;
import com.degoos.wetsponge.scoreboard.WSTeam;
import com.degoos.wetsponge.text.WSText;
import com.degoos.wetsponge.util.Validate;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.bukkit.scoreboard.Team;

public class SpigotTeam
implements WSTeam {
    private Team team;

    public SpigotTeam(Team team) {
        Validate.notNull(team, "Team cannot be null!");
        this.team = team;
    }

    @Override
    public String getName() {
        return this.team.getName();
    }

    @Override
    public WSText getDisplayName() {
        return WSText.getByFormattingText(this.team.getDisplayName());
    }

    @Override
    public void setDisplayName(@Nullable WSText name) {
        if (name == null) {
            this.team.setDisplayName(null);
        } else {
            this.team.setDisplayName(name.toFormattingText());
        }
    }

    @Override
    public WSText getPrefix() {
        return WSText.getByFormattingText(this.team.getPrefix());
    }

    @Override
    public void setPrefix(@Nullable WSText prefix) {
        if (prefix == null) {
            this.team.setPrefix(null);
        } else {
            this.team.setPrefix(prefix.toFormattingText());
        }
    }

    @Override
    public WSText getSuffix() {
        return WSText.getByFormattingText(this.team.getSuffix());
    }

    @Override
    public void setSuffix(@Nullable WSText suffix) {
        if (suffix == null) {
            this.team.setSuffix(null);
        } else {
            this.team.setSuffix(suffix.toFormattingText());
        }
    }

    @Override
    public boolean allowFriendlyFire() {
        return this.team.allowFriendlyFire();
    }

    @Override
    public void setAllowFriendlyFire(boolean enabled) {
        this.team.setAllowFriendlyFire(enabled);
    }

    @Override
    public boolean canSeeFriendlyInvisibles() {
        return this.team.canSeeFriendlyInvisibles();
    }

    @Override
    public void setCanSeeFriendlyInvisibles(boolean enabled) {
        this.team.setCanSeeFriendlyInvisibles(enabled);
    }

    @Override
    public EnumVisibility getNameTagVisibility() {
        return EnumVisibility.getBySpigotName(this.team.getOption(Team.Option.NAME_TAG_VISIBILITY).name()).orElse(EnumVisibility.ALWAYS);
    }

    @Override
    public void setNameTagVisibility(EnumVisibility visibility) {
        Validate.notNull((Object)visibility, "Visibility cannot be null!");
        this.team.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.valueOf((String)visibility.getSpigotName()));
    }

    @Override
    public EnumVisibility getDeathMessageVisibility() {
        return EnumVisibility.getBySpigotName(this.team.getOption(Team.Option.DEATH_MESSAGE_VISIBILITY).name()).orElse(EnumVisibility.ALWAYS);
    }

    @Override
    public void setDeathMessageVisibility(EnumVisibility visibility) {
        Validate.notNull((Object)visibility, "Visibility cannot be null!");
        this.team.setOption(Team.Option.DEATH_MESSAGE_VISIBILITY, Team.OptionStatus.valueOf((String)visibility.getSpigotName()));
    }

    @Override
    public EnumCollisionRule getCollisionRule() {
        return EnumCollisionRule.getBySpigotName(this.team.getOption(Team.Option.COLLISION_RULE).name()).orElse(EnumCollisionRule.ALWAYS);
    }

    @Override
    public void setCollisionRule(EnumCollisionRule collisionRule) {
        Validate.notNull((Object)collisionRule, "Collision rule cannot be null!");
        this.team.setOption(Team.Option.COLLISION_RULE, Team.OptionStatus.valueOf((String)collisionRule.getSpigotName()));
    }

    @Override
    public Set<WSText> getMembers() {
        return this.team.getEntries().stream().map(WSText::getByFormattingText).collect(Collectors.toSet());
    }

    @Override
    public void addMember(WSText member) {
        Validate.notNull(member, "Member cannot be null!");
        this.team.addEntry(member.toFormattingText());
    }

    @Override
    public boolean removeMember(WSText member) {
        Validate.notNull(member, "Member cannot be null!");
        return this.team.removeEntry(member.toFormattingText());
    }

    @Override
    public boolean hasMember(WSText member) {
        Validate.notNull(member, "Member cannot be null!");
        return this.team.hasEntry(member.toFormattingText());
    }

    @Override
    public Optional<WSScoreboard> getScoreboard() {
        try {
            return Optional.of(new SpigotScoreboard(this.team.getScoreboard()));
        }
        catch (Throwable ex) {
            return Optional.empty();
        }
    }

    @Override
    public boolean unregister() {
        try {
            this.team.unregister();
            return true;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public Team getHandled() {
        return this.team;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpigotTeam that = (SpigotTeam)o;
        return this.team.equals(that.team);
    }

    public int hashCode() {
        return this.team.hashCode();
    }
}

