/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.resource.spigot;

import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.entity.living.merchant.SpigotVillager;
import com.degoos.wetsponge.entity.living.merchant.WSVillager;
import com.degoos.wetsponge.entity.living.player.SpigotPlayer;
import com.degoos.wetsponge.entity.living.player.WSPlayer;
import com.degoos.wetsponge.enums.EnumServerVersion;
import com.degoos.wetsponge.item.SpigotItemStack;
import com.degoos.wetsponge.merchant.OldSpigotTrade;
import com.degoos.wetsponge.merchant.WSTrade;
import com.degoos.wetsponge.util.reflection.NMSUtils;
import com.degoos.wetsponge.util.reflection.ReflectionUtils;
import com.degoos.wetsponge.util.reflection.SpigotHandledUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Villager;
import org.bukkit.inventory.ItemStack;

public class SpigotMerchantUtils {
    public static Class<?> getOBCItemStackClass() {
        return NMSUtils.getOBCClass("inventory.CraftItemStack");
    }

    public static Class<?> getNMSMerchantRecipeClass() {
        return NMSUtils.getNMSClass("MerchantRecipe");
    }

    public static ItemStack asBukkitCopy(Object nmsItemStack) {
        try {
            Method m3 = SpigotMerchantUtils.getOBCItemStackClass().getDeclaredMethod("asBukkitCopy", NMSUtils.getNMSClass("ItemStack"));
            m3.setAccessible(true);
            return (ItemStack)m3.invoke(null, nmsItemStack);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object asNMSCopy(ItemStack stack) {
        try {
            Method m3 = SpigotMerchantUtils.getOBCItemStackClass().getDeclaredMethod("asNMSCopy", ItemStack.class);
            m3.setAccessible(true);
            return m3.invoke(null, stack);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Object createNMSRecipe(WSTrade trade) {
        try {
            Object item1 = SpigotMerchantUtils.asNMSCopy(((SpigotItemStack)trade.getFirstItem()).getHandled());
            Object item2 = !trade.getSecondItem().isPresent() ? null : SpigotMerchantUtils.asNMSCopy(((SpigotItemStack)trade.getSecondItem().get()).getHandled());
            Object item3 = SpigotMerchantUtils.asNMSCopy(((SpigotItemStack)trade.getResult()).getHandled());
            Class<?> isClass = NMSUtils.getNMSClass("ItemStack");
            return SpigotMerchantUtils.getNMSMerchantRecipeClass().getDeclaredConstructor(isClass, isClass, isClass, Integer.TYPE, Integer.TYPE).newInstance(item1, item2, item3, trade.getUses(), trade.getMaxUses());
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static WSTrade createWSTrade(Object nmsOffer) {
        Field[] fields = SpigotMerchantUtils.getNMSMerchantRecipeClass().getDeclaredFields();
        Arrays.stream(fields).forEach(field -> field.setAccessible(true));
        try {
            return new OldSpigotTrade(fields[3].getInt(nmsOffer), fields[4].getInt(nmsOffer), new SpigotItemStack(SpigotMerchantUtils.asBukkitCopy(fields[0].get(nmsOffer))), new SpigotItemStack(SpigotMerchantUtils.asBukkitCopy(fields[1].get(nmsOffer))), new SpigotItemStack(SpigotMerchantUtils.asBukkitCopy(fields[2].get(nmsOffer))), fields[5].getBoolean(nmsOffer));
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static ArrayList<?> getMerchantRecipeList(WSVillager villager) {
        Villager spigotVillager = ((SpigotVillager)villager).getHandled();
        Object minecraftVillager = SpigotHandledUtils.getEntityHandle((Entity)spigotVillager);
        try {
            Field field = NMSUtils.getNMSClass("EntityVillager").getDeclaredField("br");
            ReflectionUtils.setAccessible(field);
            ArrayList arrayList = (ArrayList)field.get(minecraftVillager);
            if (arrayList == null) {
                SpigotMerchantUtils.createNewList();
            }
            return arrayList;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return SpigotMerchantUtils.createNewList();
        }
    }

    public static ArrayList<?> createNewList() {
        try {
            return (ArrayList)NMSUtils.getNMSClass("MerchantRecipeList").newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void setMerchantRecipeList(WSVillager villager, List<?> arrayList) {
        Villager spigotVillager = ((SpigotVillager)villager).getHandled();
        Object minecraftVillager = SpigotHandledUtils.getEntityHandle((Entity)spigotVillager);
        try {
            Field field = NMSUtils.getNMSClass("EntityVillager").getDeclaredField("br");
            ReflectionUtils.setAccessible(field);
            field.set(minecraftVillager, arrayList);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static List<WSTrade> getTrades(WSVillager villager) {
        return SpigotMerchantUtils.getMerchantRecipeList(villager).stream().map(SpigotMerchantUtils::createWSTrade).collect(Collectors.toList());
    }

    public static void setTrades(WSVillager villager, List<WSTrade> trades) {
        ArrayList<?> list = SpigotMerchantUtils.createNewList();
        trades.stream().map(SpigotMerchantUtils::createNMSRecipe).forEach(trade -> SpigotMerchantUtils.add(list, trade));
        SpigotMerchantUtils.setMerchantRecipeList(villager, list);
    }

    private static void add(List<?> list, Object recipe) {
        try {
            Method m3 = ReflectionUtils.getMethodByName(List.class, "add");
            m3.setAccessible(true);
            m3.invoke(list, recipe);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void openGUI(WSPlayer player, WSVillager villager) {
        try {
            Villager spigotVillager = ((SpigotVillager)villager).getHandled();
            Object entityPlayer = SpigotHandledUtils.getPlayerHandle(((SpigotPlayer)player).getHandled());
            Object v = spigotVillager.getClass().getDeclaredMethod("getHandle", new Class[0]).invoke((Object)spigotVillager, new Object[0]);
            if (WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD)) {
                if (WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_1_10_2)) {
                    v.getClass().getDeclaredMethod("a", NMSUtils.getNMSClass("EntityHuman"), NMSUtils.getNMSClass("EnumHand")).invoke(v, entityPlayer, NMSUtils.getNMSClass("EnumHand").getEnumConstants()[0]);
                } else {
                    v.getClass().getDeclaredMethod("a", NMSUtils.getNMSClass("EntityHuman"), NMSUtils.getNMSClass("EnumHand"), NMSUtils.getNMSClass("ItemStack")).invoke(v, entityPlayer, NMSUtils.getNMSClass("EnumHand").getEnumConstants()[0], NMSUtils.getOBCClass("inventory.CraftItemStack").getMethod("asNMSCopy", ItemStack.class).invoke(null, new ItemStack(Material.STONE)));
                }
            } else {
                v.getClass().getDeclaredMethod("a", NMSUtils.getNMSClass("EntityHuman")).invoke(v, entityPlayer);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }
}

