/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.plugin;

import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.bridge.plugin.BridgePluginManager;
import com.degoos.wetsponge.enums.EnumLoadPluginStatus;
import com.degoos.wetsponge.enums.EnumTextColor;
import com.degoos.wetsponge.event.plugin.WSPluginEnableEvent;
import com.degoos.wetsponge.exception.plugin.WSDependencyNotFoundException;
import com.degoos.wetsponge.exception.plugin.WSInvalidPluginException;
import com.degoos.wetsponge.plugin.WSBasePlugin;
import com.degoos.wetsponge.plugin.WSPlugin;
import com.degoos.wetsponge.plugin.WSPluginDescription;
import com.degoos.wetsponge.plugin.WSPluginLoader;
import com.degoos.wetsponge.plugin.preload.LanguageDependPostload;
import com.degoos.wetsponge.plugin.preload.LanguagesPreload;
import com.degoos.wetsponge.plugin.preload.Preload;
import com.degoos.wetsponge.text.WSText;
import com.degoos.wetsponge.util.InternalLogger;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class WSPluginManager {
    private static WSPluginManager ourInstance = new WSPluginManager();
    private List<WSPlugin> plugins = new CopyOnWriteArrayList<WSPlugin>();
    private Map<String, File> pluginFiles = new ConcurrentHashMap<String, File>();
    private Set<Preload> preloads = Collections.newSetFromMap(new ConcurrentHashMap());
    private boolean loaded = false;
    private File pluginFolder;

    private WSPluginManager() {
        this.preloads.add(new LanguagesPreload());
    }

    public static WSPluginManager getInstance() {
        return ourInstance;
    }

    public void loadPlugins() {
        if (this.loaded) {
            return;
        }
        if (WetSponge.getPluginManager().getBasePlugin("Multiverse-Core").isPresent()) {
            InternalLogger.sendWarning("-----------------------------------------------------");
            InternalLogger.sendWarning("");
            InternalLogger.sendWarning("You're using Multiverse-Core! This plugin breaks minigame and world plugins.");
            InternalLogger.sendWarning("Please unistall it before sending an error.");
            InternalLogger.sendWarning("");
            InternalLogger.sendWarning("-----------------------------------------------------");
        }
        this.pluginFolder = new File("WetSpongePlugins");
        if (!this.pluginFolder.exists()) {
            this.pluginFolder.mkdirs();
        } else if (this.pluginFolder.isFile()) {
            this.pluginFolder.delete();
            this.pluginFolder.mkdirs();
        }
        HashMap descriptions = new HashMap();
        Arrays.stream(this.pluginFolder.listFiles()).filter(File::isFile).filter(file -> file.getName().toLowerCase().endsWith(".jar")).forEach(file -> {
            try {
                WSPluginDescription description = WSPluginLoader.getInstance().getPluginDescription((File)file);
                Optional<Preload> optional = this.preloads.stream().filter(preload -> preload.getPluginId().equals(description.getName())).findAny();
                if (optional.isPresent()) {
                    File newFile = optional.get().onLoad(description, (File)file);
                    if (newFile == null) {
                        descriptions.put(description, file);
                    } else {
                        descriptions.put(WSPluginLoader.getInstance().getPluginDescription(newFile), newFile);
                    }
                } else {
                    descriptions.put(description, file);
                }
            }
            catch (Throwable ex) {
                InternalLogger.sendError("Error while loading a plugin!");
                ex.printStackTrace();
            }
        });
        descriptions.entrySet().forEach(entry -> {
            try {
                if (this.plugins.stream().anyMatch(plugin -> plugin.getPluginDescription().getName().equalsIgnoreCase(((WSPluginDescription)entry.getKey()).getName()))) {
                    WSPlugin plugin2 = this.getPlugin(((WSPluginDescription)entry.getKey()).getName()).get();
                    if (plugin2.getPluginDescription().getMain().equals(((WSPluginDescription)entry.getKey()).getMain())) {
                        return;
                    }
                    throw new WSInvalidPluginException("The plugin " + ((WSPluginDescription)entry.getKey()).getName() + " already exist!");
                }
                this.loadPlugin(descriptions, (Map.Entry<WSPluginDescription, File>)entry);
            }
            catch (StackOverflowError ex) {
                InternalLogger.printException((Throwable)ex, WSText.builder("An error has occurred while WetSponge was loading the plugin ").append(WSText.of(((WSPluginDescription)entry.getKey()).getName(), EnumTextColor.YELLOW)).append(WSText.of("! Circular dependency error.")).build());
            }
            catch (Throwable ex) {
                InternalLogger.printException(ex, WSText.builder("An error has occurred while WetSponge was loading the plugin ").append(WSText.of(((WSPluginDescription)entry.getKey()).getName(), EnumTextColor.YELLOW)).append(WSText.of("!")).build());
            }
        });
        this.loaded = true;
        for (WSPlugin plugin : this.plugins) {
            InternalLogger.sendInfo(WSText.builder("Loading plugin ").append(WSText.builder(plugin.getId() + " ").color(EnumTextColor.YELLOW).build()).append(WSText.builder(plugin.getPluginDescription().getVersion()).color(EnumTextColor.RED).build()).append(WSText.builder(".").color(EnumTextColor.AQUA).build()).build());
            try {
                plugin.setEnabled(true);
                if (plugin.getPluginDescription().getDepend().contains("Languages") && !LanguageDependPostload.check(plugin)) {
                    continue;
                }
            }
            catch (Throwable ex) {
                InternalLogger.printException(ex, WSText.builder("An error has occurred while WetSponge was loading the plugin ").append(WSText.of(plugin.getId(), EnumTextColor.YELLOW)).append(WSText.of("!")).build());
            }
            WetSponge.getEventManager().callEvent(new WSPluginEnableEvent(plugin));
        }
    }

    private void loadPlugin(Map<WSPluginDescription, File> descriptions, Map.Entry<WSPluginDescription, File> entry) throws WSDependencyNotFoundException, WSInvalidPluginException {
        Optional<WSPlugin> targetedPlugin;
        Optional<Map.Entry> optional;
        for (String dependency : entry.getKey().getDepend()) {
            optional = descriptions.entrySet().stream().filter(target -> ((WSPluginDescription)target.getKey()).getName().equals(dependency)).findAny();
            if (!optional.isPresent()) {
                throw new WSDependencyNotFoundException("Cannot found dependency " + dependency);
            }
            targetedPlugin = this.plugins.stream().filter(plugin -> plugin.getPluginDescription().getName().equals(dependency)).findAny();
            if (targetedPlugin.isPresent()) continue;
            this.loadPlugin(descriptions, optional.get());
        }
        for (String dependency : entry.getKey().getSoftDepend()) {
            optional = descriptions.entrySet().stream().filter(target -> ((WSPluginDescription)target.getKey()).getName().equals(dependency)).findAny();
            if (!optional.isPresent() || (targetedPlugin = this.plugins.stream().filter(plugin -> plugin.getPluginDescription().getName().equals(dependency)).findAny()).isPresent()) continue;
            this.loadPlugin(descriptions, optional.get());
        }
        WSPlugin plugin2 = WSPluginLoader.getInstance().loadPlugin(entry.getValue());
        this.plugins.add(plugin2);
        this.pluginFiles.put(plugin2.getId().toLowerCase(), entry.getValue());
    }

    public EnumLoadPluginStatus loadPlugin(File file) {
        return this.loadPlugin(file, true);
    }

    public EnumLoadPluginStatus loadPlugin(File file, boolean executePreload) {
        String name = file.getName();
        try {
            File newFile;
            Optional optional;
            WSPluginDescription description = WSPluginLoader.getInstance().getPluginDescription(file);
            String pluginId = description.getName();
            if (this.plugins.stream().anyMatch(plugin -> plugin.getPluginDescription().getName().equalsIgnoreCase(pluginId))) {
                return EnumLoadPluginStatus.ALREADY_LOADED;
            }
            Optional<Object> optional2 = optional = !executePreload ? Optional.empty() : this.preloads.stream().filter(preload -> preload.getPluginId().equals(pluginId)).findAny();
            if (optional.isPresent() && (newFile = ((Preload)optional.get()).onLoad(description, file)) != null) {
                return this.loadPlugin(newFile, false);
            }
            name = description.getName();
            WSPlugin plugin2 = WSPluginLoader.getInstance().loadPlugin(file);
            InternalLogger.sendInfo(WSText.builder("Loading plugin ").append(WSText.builder(plugin2.getId() + " ").color(EnumTextColor.YELLOW).build()).append(WSText.builder(plugin2.getPluginDescription().getVersion()).color(EnumTextColor.RED).build()).append(WSText.builder(".").color(EnumTextColor.AQUA).build()).build());
            this.plugins.add(plugin2);
            this.pluginFiles.put(plugin2.getId().toLowerCase(), file);
            plugin2.setEnabled(true);
            if (plugin2.getPluginDescription().getDepend().contains("Languages") && !LanguageDependPostload.check(plugin2)) {
                return EnumLoadPluginStatus.ERROR;
            }
            WetSponge.getEventManager().callEvent(new WSPluginEnableEvent(plugin2));
        }
        catch (Throwable ex) {
            InternalLogger.printException(ex, WSText.builder("An error has occurred while WetSponge was loading the plugin ").append(WSText.of(name, EnumTextColor.YELLOW)).append(WSText.of("!")).build());
            return EnumLoadPluginStatus.ERROR;
        }
        return EnumLoadPluginStatus.LOADED;
    }

    public void unloadPlugin(WSPlugin plugin) {
        WSPluginLoader.getInstance().disablePlugin(plugin);
        this.plugins.remove(plugin);
    }

    public File getPluginFolder() {
        return this.pluginFolder;
    }

    public Set<WSPlugin> getPlugins() {
        return new HashSet<WSPlugin>(this.plugins);
    }

    public Optional<File> getPluginFile(String name) {
        return Optional.ofNullable(this.pluginFiles.get(name.toLowerCase()));
    }

    public Map<String, File> getPluginFiles() {
        return new HashMap<String, File>(this.pluginFiles);
    }

    public Optional<WSPlugin> getPlugin(String name) {
        return this.plugins.stream().filter(plugin -> plugin.getId().equalsIgnoreCase(name)).findAny();
    }

    public boolean isPluginEnabled(String name) {
        return this.getPlugin(name).isPresent();
    }

    public Set<WSBasePlugin> getBasePlugins() {
        return BridgePluginManager.getBasePlugins();
    }

    public Optional<WSBasePlugin> getBasePlugin(String name) {
        return this.getBasePlugins().stream().filter(target -> target.getName().equals(name)).findAny();
    }

    public boolean isBasePluginEnabled(String name) {
        return BridgePluginManager.isBasePluginEnabled(name);
    }
}

