/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.plugin;

import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.enums.EnumTextColor;
import com.degoos.wetsponge.event.plugin.WSPluginDisableEvent;
import com.degoos.wetsponge.exception.plugin.WSInvalidDescriptionException;
import com.degoos.wetsponge.exception.plugin.WSInvalidPluginException;
import com.degoos.wetsponge.exception.plugin.WSUnknownDependencyException;
import com.degoos.wetsponge.plugin.WSPlugin;
import com.degoos.wetsponge.plugin.WSPluginClassLoader;
import com.degoos.wetsponge.plugin.WSPluginDescription;
import com.degoos.wetsponge.task.WSTaskPool;
import com.degoos.wetsponge.text.WSText;
import com.degoos.wetsponge.util.InternalLogger;
import com.degoos.wetsponge.util.Validate;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class WSPluginLoader {
    private static WSPluginLoader ourInstance = new WSPluginLoader();
    private final List<WSPluginClassLoader> loaders = new CopyOnWriteArrayList<WSPluginClassLoader>();

    private WSPluginLoader() {
    }

    public static WSPluginLoader getInstance() {
        return ourInstance;
    }

    public WSPlugin loadPlugin(File file) throws WSInvalidPluginException {
        WSPluginClassLoader loader;
        WSPluginDescription description;
        Validate.notNull(file, "File cannot be null");
        if (!file.exists()) {
            throw new WSInvalidPluginException(new FileNotFoundException(file.getPath() + " does not exist"));
        }
        try {
            description = this.getPluginDescription(file);
        }
        catch (WSInvalidDescriptionException ex) {
            throw new WSInvalidPluginException(ex);
        }
        File parentFile = file.getParentFile();
        File dataFolder = new File(parentFile, description.getName());
        if (dataFolder.exists() && !dataFolder.isDirectory()) {
            throw new WSInvalidPluginException(String.format("Projected datafolder: `%s' for %s (%s) exists and is not a directory", dataFolder, description.getFullName(), file));
        }
        for (String pluginName : description.getDepend()) {
            if (WetSponge.getPluginManager().getPlugin(pluginName).isPresent()) continue;
            throw new WSInvalidPluginException(new WSUnknownDependencyException(pluginName));
        }
        try {
            loader = new WSPluginClassLoader(this.getClass().getClassLoader(), description, file);
        }
        catch (WSInvalidPluginException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new WSInvalidPluginException(ex);
        }
        this.loaders.add(loader);
        return loader.getPlugin();
    }

    public WSPluginDescription getPluginDescription(File file) throws WSInvalidDescriptionException {
        Validate.notNull(file, "File cannot be null");
        JarFile jar = null;
        InputStream stream = null;
        try {
            jar = new JarFile(file);
            JarEntry entry = jar.getJarEntry("plugin.yml");
            if (entry == null) {
                throw new WSInvalidDescriptionException(new FileNotFoundException("Jar does not contain plugin.yml"));
            }
            stream = jar.getInputStream(entry);
            WSPluginDescription wSPluginDescription = new WSPluginDescription(stream);
            return wSPluginDescription;
        }
        catch (Throwable ex) {
            throw new WSInvalidDescriptionException(ex);
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException iOException) {}
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public WSPluginDescription getPluginFile(File file, String name) throws WSInvalidDescriptionException {
        Validate.notNull(file, "File cannot be null");
        JarFile jar = null;
        InputStream stream = null;
        try {
            jar = new JarFile(file);
            JarEntry entry = jar.getJarEntry(name);
            if (entry == null) {
                throw new WSInvalidDescriptionException(new FileNotFoundException("Jar does not contain plugin.yml"));
            }
            stream = jar.getInputStream(entry);
            WSPluginDescription wSPluginDescription = new WSPluginDescription(stream);
            return wSPluginDescription;
        }
        catch (Throwable ex) {
            throw new WSInvalidDescriptionException(ex);
        }
        finally {
            if (jar != null) {
                try {
                    jar.close();
                }
                catch (IOException iOException) {}
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void disablePlugin(WSPlugin plugin) {
        if (plugin.isEnabled()) {
            WetSponge.getEventManager().callEvent(new WSPluginDisableEvent(plugin));
            WSPluginClassLoader classLoader = plugin.getClassLoader();
            this.loaders.remove(classLoader);
            WetSponge.getEventManager().unregisterListeners(plugin);
            WSTaskPool.removeTasks(plugin);
            try {
                plugin.setEnabled(false);
                classLoader.close();
            }
            catch (Throwable ex) {
                InternalLogger.printException(ex, WSText.builder("An error has occurred while WetSponge was unloading the plugin ").append(WSText.of(plugin.getId(), EnumTextColor.YELLOW)).append(WSText.of("!")).build());
                ex.printStackTrace();
            }
        }
    }
}

