/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.plugin;

import com.degoos.wetsponge.exception.plugin.WSInvalidPluginException;
import com.degoos.wetsponge.plugin.WSPlugin;
import com.degoos.wetsponge.plugin.WSPluginDescription;
import com.degoos.wetsponge.plugin.WSPluginManager;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class WSPluginClassLoader
extends URLClassLoader {
    private final WSPlugin plugin;
    private final Map<String, Class<?>> classes = new HashMap();
    private File file;

    WSPluginClassLoader(ClassLoader parent, WSPluginDescription description, File file) throws WSInvalidPluginException, MalformedURLException {
        super(new URL[]{file.toURI().toURL()}, parent);
        this.file = file;
        try {
            Class<WSPlugin> pluginClass;
            Class<?> jarClass;
            try {
                jarClass = Class.forName(description.getMain(), true, this);
            }
            catch (ClassNotFoundException ex) {
                throw new WSInvalidPluginException(ex, "Cannot find main class `" + description.getMain() + "'");
            }
            try {
                pluginClass = jarClass.asSubclass(WSPlugin.class);
            }
            catch (ClassCastException ex) {
                throw new WSInvalidPluginException(ex, "main class `" + description.getMain() + "' does not extend WSPlugin");
            }
            this.plugin = pluginClass.newInstance();
            this.plugin.init(this, description);
        }
        catch (IllegalAccessException ex) {
            throw new WSInvalidPluginException(ex, "No public constructor");
        }
        catch (InstantiationException ex) {
            throw new WSInvalidPluginException(ex, "Abnormal plugin item");
        }
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        return this.findClass(name, true);
    }

    public Class<?> findClass(String name, boolean checkGlobal) throws ClassNotFoundException {
        Class result = this.classes.get(name);
        if (result == null) {
            if (checkGlobal) {
                result = WSPluginManager.getInstance().getPlugins().stream().map(target -> {
                    try {
                        return target.getClassLoader().findClass(name, false);
                    }
                    catch (ClassNotFoundException e) {
                        return null;
                    }
                }).filter(Objects::nonNull).findAny().orElse(null);
            }
            if (result == null && (result = super.findClass(name)) != null) {
                this.classes.put(name, result);
            }
            this.classes.put(name, result);
        }
        return result;
    }

    public File getFile() {
        return this.file;
    }

    public WSPlugin getPlugin() {
        return this.plugin;
    }
}

