/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.particle;

import com.degoos.wetsponge.entity.living.player.SpongePlayer;
import com.degoos.wetsponge.entity.living.player.WSPlayer;
import com.degoos.wetsponge.exception.particle.WSInvalidParticleException;
import com.degoos.wetsponge.particle.WSParticle;
import com.degoos.wetsponge.world.WSLocation;
import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3f;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.effect.particle.ParticleEffect;
import org.spongepowered.api.effect.particle.ParticleType;

public class SpongeParticle
implements WSParticle {
    private String id;
    private String minecraftId;
    private String spigotName;
    private ParticleType effect;

    public SpongeParticle(String id, String minecraftId, String spigotName) {
        this.id = id;
        this.minecraftId = minecraftId;
        this.spigotName = spigotName;
        Optional optional = Sponge.getRegistry().getType(ParticleType.class, minecraftId);
        if (!optional.isPresent()) {
            throw new WSInvalidParticleException("Cannot found particle " + minecraftId + "!");
        }
        this.effect = (ParticleType)optional.get();
    }

    @Override
    public void spawnParticle(WSLocation location, float speed, int amount, WSPlayer ... players) {
        this.spawnParticle(location, speed, amount, new Vector3f(1.0f, 1.0f, 1.0f), players);
    }

    @Override
    public void spawnParticle(WSLocation location, float speed, int amount, Collection<WSPlayer> players) {
        this.spawnParticle(location, speed, amount, new Vector3f(1.0f, 1.0f, 1.0f), players);
    }

    @Override
    public void spawnParticle(WSLocation location, float speed, int amount, Vector3d playerRadius) {
        this.spawnParticle(location, speed, amount, new Vector3f(1.0f, 1.0f, 1.0f), playerRadius);
    }

    @Override
    public void spawnParticle(WSLocation location, float speed, int amount, Vector3f radius, WSPlayer ... players) {
        this.spawnParticle(location, speed, amount, radius, Arrays.asList(players));
    }

    @Override
    public void spawnParticle(WSLocation location, float speed, int amount, Vector3f radius, Collection<WSPlayer> players) {
        if (this.effect == null) {
            return;
        }
        players.forEach(player -> ((SpongePlayer)player).getHandled().spawnParticles(ParticleEffect.builder().type(this.effect).offset(new Vector3d(radius.getX(), radius.getY(), radius.getZ())).velocity(new Vector3d(speed, speed, speed)).quantity(amount).build(), location.toVector3d()));
    }

    @Override
    public void spawnParticle(WSLocation location, float speed, int amount, Vector3f radius, Vector3d playerRadius) {
        this.spawnParticle(location, speed, amount, radius, location.getNearbyPlayers(playerRadius));
    }

    @Override
    public String getOldMinecraftId() {
        return this.id;
    }

    @Override
    public String getMinecraftId() {
        return this.minecraftId;
    }

    @Override
    public String getSpigotName() {
        return this.spigotName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpongeParticle that = (SpongeParticle)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

