/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.parser.player;

import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.entity.living.player.Spigot13Player;
import com.degoos.wetsponge.entity.living.player.SpigotPlayer;
import com.degoos.wetsponge.entity.living.player.SpongePlayer;
import com.degoos.wetsponge.entity.living.player.WSPlayer;
import com.degoos.wetsponge.enums.EnumServerVersion;
import com.degoos.wetsponge.parser.player.Spigot13PlayerParser;
import com.degoos.wetsponge.parser.player.SpigotPlayerParser;
import com.degoos.wetsponge.parser.player.SpongePlayerParser;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;

public class PlayerParser {
    private static Map<UUID, WSPlayer> players = new HashMap<UUID, WSPlayer>();

    public static WSPlayer addPlayer(WSPlayer player) {
        players.putIfAbsent(player.getUniqueId(), player);
        return players.get(player.getUniqueId());
    }

    public static void removePlayer(WSPlayer player) {
        players.remove(player.getUniqueId());
    }

    public static void resetPlayer(Object handled, UUID uuid) {
        if (handled instanceof WSPlayer) {
            handled = ((WSPlayer)handled).getHandled();
        }
        switch (WetSponge.getServerType()) {
            case SPIGOT: 
            case PAPER_SPIGOT: {
                if (WetSponge.getVersion().isOlderThan(EnumServerVersion.MINECRAFT_1_13)) {
                    ((SpigotPlayer)PlayerParser.getPlayer(uuid).orElseThrow(NullPointerException::new)).setHandled(handled);
                    break;
                }
                ((Spigot13Player)PlayerParser.getPlayer(uuid).orElseThrow(NullPointerException::new)).setHandled(handled);
                break;
            }
            case SPONGE: {
                ((SpongePlayer)PlayerParser.getPlayer(uuid).orElseThrow(NullPointerException::new)).setHandled(handled);
            }
        }
    }

    public static Optional<WSPlayer> getPlayer(UUID uuid) {
        WSPlayer player = players.get(uuid);
        if (player != null) {
            return Optional.of(player);
        }
        switch (WetSponge.getServerType()) {
            case SPONGE: {
                return SpongePlayerParser.checkPlayer(uuid);
            }
            case SPIGOT: 
            case PAPER_SPIGOT: {
                if (WetSponge.getVersion().isOlderThan(EnumServerVersion.MINECRAFT_1_13)) {
                    return SpigotPlayerParser.checkPlayer(uuid);
                }
                return Spigot13PlayerParser.checkPlayer(uuid);
            }
        }
        return Optional.empty();
    }

    public static WSPlayer getOrCreatePlayer(Object entity, UUID uuid) {
        Optional<WSPlayer> optional = PlayerParser.getPlayer(uuid);
        if (optional.isPresent()) {
            return optional.get();
        }
        switch (WetSponge.getServerType()) {
            case SPONGE: {
                return PlayerParser.addPlayer(SpongePlayerParser.newInstance(entity));
            }
            case SPIGOT: 
            case PAPER_SPIGOT: {
                if (WetSponge.getVersion().isOlderThan(EnumServerVersion.MINECRAFT_1_13)) {
                    return PlayerParser.addPlayer(SpigotPlayerParser.newInstance(entity));
                }
                return PlayerParser.addPlayer(Spigot13PlayerParser.newInstance(entity));
            }
        }
        return null;
    }

    public static Optional<WSPlayer> getPlayer(String name) {
        Optional<WSPlayer> optional = players.values().stream().filter(player -> player.getName().equals(name)).findAny();
        if (optional.isPresent()) {
            return optional;
        }
        switch (WetSponge.getServerType()) {
            case SPONGE: {
                return SpongePlayerParser.checkPlayer(name);
            }
            case SPIGOT: 
            case PAPER_SPIGOT: {
                if (WetSponge.getVersion().isOlderThan(EnumServerVersion.MINECRAFT_1_13)) {
                    return SpigotPlayerParser.checkPlayer(name);
                }
                return Spigot13PlayerParser.checkPlayer(name);
            }
        }
        return Optional.empty();
    }
}

