/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.parser.entity;

import com.degoos.wetsponge.enums.EnumEntityType;
import com.degoos.wetsponge.util.Validate;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;

public class Spigot13EntityData {
    private EntityType spongeEntityType;
    private EnumEntityType entityType;
    private Class<? extends Entity> entityClass;

    public Spigot13EntityData(EntityType spongeEntityType, EnumEntityType entityType, Class<? extends Entity> entityClass) {
        Validate.notNull(spongeEntityType, "Sponge entity type cannot be null!");
        Validate.notNull((Object)entityType, "Entity type cannot be null!");
        Validate.notNull(entityClass, "Entity class cannot be null!");
        this.spongeEntityType = spongeEntityType;
        this.entityType = entityType;
        this.entityClass = entityClass;
    }

    public Spigot13EntityData(EntityType spongeEntityType, EnumEntityType entityType) {
        Validate.notNull(spongeEntityType, "Sponge entity type cannot be null!");
        Validate.notNull((Object)entityType, "Entity type cannot be null!");
        this.spongeEntityType = spongeEntityType;
        this.entityType = entityType;
        this.entityClass = spongeEntityType.getEntityClass();
    }

    public EntityType getSpongeEntityType() {
        return this.spongeEntityType;
    }

    public void setSpongeEntityType(EntityType spongeEntityType) {
        Validate.notNull(spongeEntityType, "Sponge entity type cannot be null!");
        this.spongeEntityType = spongeEntityType;
    }

    public EnumEntityType getEntityType() {
        return this.entityType;
    }

    public void setEntityType(EnumEntityType entityType) {
        Validate.notNull((Object)entityType, "Entity type cannot be null!");
        this.entityType = entityType;
    }

    public Class<? extends Entity> getEntityClass() {
        return this.entityClass;
    }

    public void setEntityClass(Class<? extends Entity> entityClass) {
        Validate.notNull(entityClass, "Entity class cannot be null!");
        this.entityClass = entityClass;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Spigot13EntityData that = (Spigot13EntityData)o;
        return this.entityType == that.entityType;
    }

    public int hashCode() {
        return this.entityType.hashCode();
    }
}

