/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.packet.play.server;

import com.degoos.wetsponge.entity.living.player.WSHuman;
import com.degoos.wetsponge.packet.SpongePacket;
import com.degoos.wetsponge.packet.play.server.WSSPacketUseBed;
import com.degoos.wetsponge.util.InternalLogger;
import com.flowpowered.math.vector.Vector3i;
import java.lang.reflect.Field;
import java.util.Arrays;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUseBed;
import net.minecraft.util.math.BlockPos;

public class SpongeSPacketUseBed
extends SpongePacket
implements WSSPacketUseBed {
    private int entityId;
    private Vector3i position;
    private boolean changed;

    public SpongeSPacketUseBed(int entityId, Vector3i position) {
        super((Packet<?>)new SPacketUseBed());
        this.position = position;
        this.entityId = entityId;
        this.update();
    }

    public SpongeSPacketUseBed(WSHuman human, Vector3i position) {
        super((Packet<?>)new SPacketUseBed());
        this.position = position;
        this.entityId = human.getEntityId();
        this.update();
    }

    public SpongeSPacketUseBed(Packet<?> packet) {
        super(packet);
        this.refresh();
    }

    @Override
    public void update() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            fields[0].setInt(this.getHandler(), this.entityId);
            fields[1].set(this.getHandler(), new BlockPos(this.position.getX(), this.position.getY(), this.position.getZ()));
        }
        catch (Throwable ex) {
            InternalLogger.printException(ex, "An error has occurred while WetSponge was updating a packet!");
        }
    }

    @Override
    public void refresh() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            this.entityId = fields[0].getInt(this.getHandler());
            BlockPos pos = (BlockPos)fields[1].get(this.getHandler());
            this.position = new Vector3i(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        catch (Throwable ex) {
            InternalLogger.printException(ex, "An error has occurred while WetSponge was refreshing a packet!");
            this.entityId = 0;
            this.position = new Vector3i(0, 0, 0);
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public int getEntityId() {
        return this.entityId;
    }

    @Override
    public void setEntityId(int entityId) {
        this.entityId = entityId;
    }

    @Override
    public Vector3i getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Vector3i position) {
        this.position = position;
        this.changed = true;
    }
}

