/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.packet.play.server;

import com.degoos.wetsponge.packet.SpongePacket;
import com.degoos.wetsponge.packet.play.server.WSSPacketSignEditorOpen;
import com.degoos.wetsponge.util.Validate;
import com.flowpowered.math.vector.Vector3d;
import java.lang.reflect.Field;
import java.util.Arrays;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSignEditorOpen;
import net.minecraft.util.math.BlockPos;

public class SpongeSPacketSignEditorOpen
extends SpongePacket
implements WSSPacketSignEditorOpen {
    private Vector3d position;
    private boolean changed;

    public SpongeSPacketSignEditorOpen(Vector3d position) {
        super((Packet<?>)new SPacketSignEditorOpen());
        Validate.notNull(position, "Position cannot be null!");
        this.position = position;
        this.update();
    }

    public SpongeSPacketSignEditorOpen(Packet<?> packet) {
        super(packet);
        this.refresh();
    }

    @Override
    public void update() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            fields[0].set(this.getHandler(), new BlockPos(this.position.getX(), this.position.getY(), this.position.getZ()));
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void refresh() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            BlockPos blockPos = (BlockPos)fields[0].get(this.getHandler());
            this.position = new Vector3d(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public Vector3d getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Vector3d position) {
        Validate.notNull(position, "Position cannot be null!");
        this.position = position;
        this.changed = true;
    }
}

