/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.packet.play.server;

import com.degoos.wetsponge.packet.SpongePacket;
import com.degoos.wetsponge.packet.play.server.WSSPacketServerInfo;
import com.degoos.wetsponge.server.response.WSServerStatusResponse;
import com.degoos.wetsponge.server.response.WSStatusPlayers;
import com.degoos.wetsponge.server.response.WSStatusVersion;
import com.degoos.wetsponge.text.SpongeText;
import com.degoos.wetsponge.text.WSText;
import com.degoos.wetsponge.user.SpongeGameProfile;
import com.degoos.wetsponge.util.ListUtils;
import com.degoos.wetsponge.util.Validate;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.network.Packet;
import net.minecraft.network.ServerStatusResponse;
import net.minecraft.network.play.server.SPacketSignEditorOpen;
import net.minecraft.util.text.ITextComponent;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.text.Text;

public class SpongeSPacketServerInfo
extends SpongePacket
implements WSSPacketServerInfo {
    private WSServerStatusResponse response;
    private boolean changed;

    public SpongeSPacketServerInfo(WSServerStatusResponse response) {
        super((Packet<?>)new SPacketSignEditorOpen());
        Validate.notNull(response, "Response cannot be null!");
        this.response = response;
        this.changed = false;
        this.update();
    }

    public SpongeSPacketServerInfo(Packet<?> packet) {
        super(packet);
        this.changed = false;
        this.refresh();
    }

    @Override
    public void update() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            ServerStatusResponse nmsResponse = new ServerStatusResponse();
            nmsResponse.func_151320_a(this.response.getFaviconString());
            nmsResponse.func_151315_a((ITextComponent)((SpongeText)this.response.getMOTD()).getHandled());
            nmsResponse.func_151321_a(new ServerStatusResponse.Version(this.response.getVersion().getName(), this.response.getVersion().getProtocol()));
            ServerStatusResponse.Players players = new ServerStatusResponse.Players(this.response.getPlayers().getMaxPlayers(), this.response.getPlayers().getPlayerCount());
            players.func_151330_a(ListUtils.toArray(com.mojang.authlib.GameProfile.class, this.response.getPlayers().getProfiles().stream().map(profile -> (com.mojang.authlib.GameProfile)profile.getHandled()).collect(Collectors.toList())));
            nmsResponse.func_151319_a(players);
            fields[1].set(this.getHandler(), nmsResponse);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void refresh() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            ServerStatusResponse nmsResponse = (ServerStatusResponse)fields[1].get(this.getHandler());
            this.response = new WSServerStatusResponse((WSText)SpongeText.of((Text)nmsResponse.func_151317_a()), nmsResponse.func_151316_d(), new WSStatusPlayers(nmsResponse.func_151318_b().func_151332_a(), nmsResponse.func_151318_b().func_151333_b(), ListUtils.toSet(nmsResponse.func_151318_b().func_151331_c()).stream().map(profile -> new SpongeGameProfile((GameProfile)profile)).collect(Collectors.toSet())), new WSStatusVersion(nmsResponse.func_151322_c().func_151303_a(), nmsResponse.func_151322_c().func_151304_b()));
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed || this.response.hasChanged();
    }

    @Override
    public WSServerStatusResponse getResponse() {
        return this.response;
    }

    @Override
    public void setResponse(WSServerStatusResponse response) {
        this.response = response;
        this.changed = true;
    }
}

