/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.packet.play.server;

import com.degoos.wetsponge.enums.EnumGameMode;
import com.degoos.wetsponge.enums.EnumPlayerListItemAction;
import com.degoos.wetsponge.packet.SpongePacket;
import com.degoos.wetsponge.packet.play.server.WSSPacketPlayerListItem;
import com.degoos.wetsponge.packet.play.server.extra.WSPlayerListItemData;
import com.degoos.wetsponge.text.SpongeText;
import com.degoos.wetsponge.user.SpongeGameProfile;
import com.degoos.wetsponge.util.ListUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketPlayerListItem;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.GameType;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.text.Text;
import org.spongepowered.common.text.SpongeTexts;

public class SpongeSPacketPlayerListItem
extends SpongePacket
implements WSSPacketPlayerListItem {
    private boolean changed = false;
    private EnumPlayerListItemAction action;
    private List<WSPlayerListItemData> data;
    private Class<?> nestedClass = SPacketPlayerListItem.class.getDeclaredClasses()[0];

    public SpongeSPacketPlayerListItem(EnumPlayerListItemAction action, Collection<WSPlayerListItemData> itemData) {
        super((Packet<?>)new SPacketPlayerListItem());
        this.action = action;
        this.data = new ArrayList<WSPlayerListItemData>(itemData);
        this.update();
    }

    public SpongeSPacketPlayerListItem(EnumPlayerListItemAction action, WSPlayerListItemData ... itemData) {
        super((Packet<?>)new SPacketPlayerListItem());
        this.action = action;
        this.data = ListUtils.toList(itemData);
        this.update();
    }

    public SpongeSPacketPlayerListItem(Packet<?> packet) {
        super(packet);
        this.refresh();
    }

    @Override
    public void update() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            fields[0].set(this.getHandler(), SPacketPlayerListItem.Action.valueOf((String)this.action.name()));
            List list = (List)fields[1].get(this.getHandler());
            list.clear();
            Constructor<?> constructor = this.nestedClass.getConstructor(SPacketPlayerListItem.class, com.mojang.authlib.GameProfile.class, Integer.TYPE, GameType.class, ITextComponent.class);
            for (WSPlayerListItemData itemData : this.data) {
                list.add(constructor.newInstance((SPacketPlayerListItem)this.getHandler(), (com.mojang.authlib.GameProfile)itemData.getGameProfile().getHandled(), itemData.getPing(), GameType.valueOf((String)(itemData.getGameMode() == null ? "NOT_SET" : itemData.getGameMode().name())), itemData.getDisplayName() == null ? null : SpongeTexts.toComponent((Text)((Text)itemData.getDisplayName().getHandled()))));
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void refresh() {
        try {
            this.data.clear();
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            this.action = EnumPlayerListItemAction.valueOf(((Enum)fields[0].get(this.getHandler())).name());
            List list = (List)fields[1].get(this.getHandler());
            for (Object o : list) {
                Field[] nestedFields = o.getClass().getDeclaredFields();
                Arrays.stream(nestedFields).forEach(field -> field.setAccessible(true));
                int ping = nestedFields[0].getInt(o);
                GameType gameType = (GameType)nestedFields[1].get(o);
                com.mojang.authlib.GameProfile profile = (com.mojang.authlib.GameProfile)nestedFields[2].get(o);
                ITextComponent displayName = (ITextComponent)nestedFields[3].get(o);
                this.data.add(new WSPlayerListItemData(ping, gameType == GameType.NOT_SET ? null : EnumGameMode.valueOf(gameType.name()), new SpongeGameProfile((GameProfile)profile), SpongeText.of(SpongeTexts.toText((ITextComponent)displayName))));
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public EnumPlayerListItemAction getAction() {
        return this.action;
    }

    @Override
    public void setAction(EnumPlayerListItemAction action) {
        this.action = action;
        this.changed = true;
    }

    @Override
    public List<WSPlayerListItemData> getData() {
        this.changed = true;
        return this.data;
    }
}

