/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.packet.play.server;

import com.degoos.wetsponge.packet.SpongePacket;
import com.degoos.wetsponge.packet.play.server.WSSPacketOpenWindow;
import com.degoos.wetsponge.text.SpongeText;
import com.degoos.wetsponge.text.WSText;
import com.degoos.wetsponge.util.InternalLogger;
import java.lang.reflect.Field;
import java.util.Arrays;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketOpenWindow;
import net.minecraft.util.text.ITextComponent;
import org.spongepowered.api.text.Text;
import org.spongepowered.common.text.SpongeTexts;

public class SpongeSPacketOpenWindow
extends SpongePacket
implements WSSPacketOpenWindow {
    private boolean changed;
    private int windowId;
    private String inventoryType;
    private WSText windowTitle;
    private int slotCount;
    private int entityId;

    public SpongeSPacketOpenWindow(int windowId, String inventoryType, WSText windowTitle, int slotCount, int entityId) {
        super((Packet<?>)new SPacketOpenWindow());
        this.windowId = windowId;
        this.inventoryType = inventoryType;
        this.windowTitle = windowTitle;
        this.slotCount = slotCount;
        this.entityId = entityId;
        this.changed = false;
        this.update();
    }

    public SpongeSPacketOpenWindow(Packet<?> packet) {
        super(packet);
        this.refresh();
        this.changed = false;
    }

    @Override
    public int getWindowId() {
        return this.windowId;
    }

    @Override
    public void setWindowId(int windowId) {
        this.windowId = windowId;
        this.changed = true;
    }

    @Override
    public String getInventoryType() {
        return this.inventoryType;
    }

    @Override
    public void setInventoryType(String inventoryType) {
        this.inventoryType = inventoryType;
        this.changed = true;
    }

    @Override
    public WSText getWindowTitle() {
        return this.windowTitle;
    }

    @Override
    public void setWindowTitle(WSText windowTitle) {
        this.windowTitle = windowTitle;
        this.changed = true;
    }

    @Override
    public int getSlotCount() {
        return this.slotCount;
    }

    @Override
    public void setSlotCount(int slotCount) {
        this.slotCount = slotCount;
        this.changed = true;
    }

    @Override
    public int getEntityId() {
        return this.entityId;
    }

    @Override
    public void setEntityId(int entityId) {
        this.entityId = entityId;
        this.changed = true;
    }

    @Override
    public void update() {
        Field[] fields = this.getHandler().getClass().getDeclaredFields();
        Arrays.stream(fields).forEach(field -> field.setAccessible(true));
        try {
            fields[0].setInt(this.getHandler(), this.windowId);
            fields[1].set(this.getHandler(), this.inventoryType);
            fields[2].set(this.getHandler(), SpongeTexts.toComponent((Text)((Text)this.windowTitle.getHandled())));
            fields[3].setInt(this.getHandler(), this.slotCount);
            fields[4].setInt(this.getHandler(), this.entityId);
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was updating a packet!");
        }
    }

    @Override
    public void refresh() {
        Field[] fields = this.getHandler().getClass().getDeclaredFields();
        Arrays.stream(fields).forEach(field -> field.setAccessible(true));
        try {
            this.windowId = fields[0].getInt(this.getHandler());
            this.inventoryType = (String)fields[1].get(this.getHandler());
            this.windowTitle = SpongeText.of(SpongeTexts.toText((ITextComponent)((ITextComponent)fields[2].get(this.getHandler()))));
            this.slotCount = fields[3].getInt(this.getHandler());
            this.entityId = fields[4].getInt(this.getHandler());
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was refreshing a packet!");
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }
}

