/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.packet.play.server;

import com.degoos.wetsponge.material.block.WSBlockType;
import com.degoos.wetsponge.packet.SpongePacket;
import com.degoos.wetsponge.packet.play.server.WSSPacketMultiBlockChange;
import com.degoos.wetsponge.parser.packet.SpongePacketParser;
import com.degoos.wetsponge.util.reflection.ReflectionUtils;
import com.flowpowered.math.vector.Vector2i;
import com.flowpowered.math.vector.Vector3i;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketMultiBlockChange;
import net.minecraft.util.math.ChunkPos;

public class SpongeSPacketMultiBlockChange
extends SpongePacket
implements WSSPacketMultiBlockChange {
    private Vector2i chunkPosition;
    private Map<Vector3i, WSBlockType> materials;
    private int index;
    private boolean changed;

    public SpongeSPacketMultiBlockChange(Vector2i chunkPosition, Map<Vector3i, WSBlockType> materials) {
        super((Packet<?>)new SPacketMultiBlockChange());
        this.chunkPosition = chunkPosition;
        this.materials = materials;
        this.update();
    }

    public SpongeSPacketMultiBlockChange(Packet<?> packet) {
        super(packet);
        this.refresh();
    }

    @Override
    public Vector2i getChunkPosition() {
        return this.chunkPosition;
    }

    @Override
    public void setChunkPosition(Vector2i chunkPosition) {
        this.changed = true;
        this.chunkPosition = chunkPosition;
    }

    @Override
    public Map<Vector3i, WSBlockType> getMaterials() {
        this.changed = true;
        return this.materials;
    }

    @Override
    public void setMaterials(Map<Vector3i, WSBlockType> materials) {
        this.changed = true;
        this.materials = materials;
    }

    @Override
    public void removeMaterial(Vector3i position) {
        this.changed = true;
        this.materials.remove(position);
    }

    @Override
    public void addMaterial(Vector3i position, WSBlockType type) {
        this.changed = true;
        this.materials.put(position, type);
    }

    @Override
    public void update() {
        this.index = 0;
        try {
            ReflectionUtils.setFirstObject(SPacketMultiBlockChange.class, ChunkPos.class, this.getHandler(), new ChunkPos(this.chunkPosition.getX(), this.chunkPosition.getY()));
            SPacketMultiBlockChange.BlockUpdateData[] data = new SPacketMultiBlockChange.BlockUpdateData[this.materials.size()];
            this.materials.forEach((vector3i, type) -> {
                try {
                    short offset = (short)(vector3i.getX() << 12 & 0xF000 | vector3i.getY() & 0xFF | vector3i.getZ() << 8 & 0xF00);
                    IBlockState state = SpongePacketParser.getBlockState(type);
                    SPacketMultiBlockChange sPacketMultiBlockChange = (SPacketMultiBlockChange)this.getHandler();
                    sPacketMultiBlockChange.getClass();
                    data[this.index] = new SPacketMultiBlockChange.BlockUpdateData(sPacketMultiBlockChange, offset, state);
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
                ++this.index;
            });
            ReflectionUtils.setAccessible(SPacketMultiBlockChange.class.getDeclaredFields()[1]).set(this.getHandler(), data);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void refresh() {
        try {
            SPacketMultiBlockChange.BlockUpdateData[] blocks = ReflectionUtils.getFirstObject(SPacketMultiBlockChange.class, SPacketMultiBlockChange.BlockUpdateData[].class, this.getHandler());
            ChunkPos pos = ReflectionUtils.getFirstObject(SPacketMultiBlockChange.class, ChunkPos.class, this.getHandler());
            this.chunkPosition = new Vector2i(pos.field_77276_a, pos.field_77275_b);
            this.materials = new HashMap<Vector3i, WSBlockType>();
            for (SPacketMultiBlockChange.BlockUpdateData data : blocks) {
                this.materials.put(new Vector3i(data.func_180089_b() >> 12 & 0xF, data.func_180089_b() & 0xFF, data.func_180089_b() >> 8 & 0xF), SpongePacketParser.getMaterial(data.func_180088_c()));
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }
}

