/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.packet.play.server;

import com.degoos.wetsponge.enums.EnumMapDecorationType;
import com.degoos.wetsponge.enums.EnumMapScale;
import com.degoos.wetsponge.map.WSMapDecoration;
import com.degoos.wetsponge.map.WSMapView;
import com.degoos.wetsponge.packet.SpongePacket;
import com.degoos.wetsponge.packet.play.server.WSSPacketMaps;
import com.degoos.wetsponge.util.Validate;
import com.flowpowered.math.vector.Vector2i;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketMaps;
import net.minecraft.world.storage.MapDecoration;

public class SpongeSPacketMaps
extends SpongePacket
implements WSSPacketMaps {
    private int mapId;
    private Vector2i origin;
    private Vector2i size;
    private WSMapView mapView;
    private boolean changed;

    public SpongeSPacketMaps(int mapId, Vector2i origin, Vector2i size, WSMapView mapView) {
        super((Packet<?>)new SPacketMaps());
        Validate.notNull(origin, "Origin cannot be null!");
        Validate.notNull(size, "Size cannot be null!");
        Validate.notNull(mapView, "MapView cannot be null!");
        this.mapId = mapId;
        this.origin = origin;
        this.size = size;
        this.mapView = mapView;
        this.update();
    }

    public SpongeSPacketMaps(Packet<?> packet) {
        super(packet);
        this.refresh();
    }

    @Override
    public void update() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            fields[0].setInt(this.getHandler(), this.mapId);
            fields[1].setByte(this.getHandler(), this.mapView.getMapScale().getId());
            fields[2].setBoolean(this.getHandler(), this.mapView.isTrackingPositions());
            fields[3].set(this.getHandler(), this.mapView.getAllDecorations().stream().map(decoration -> new MapDecoration(MapDecoration.Type.func_191159_a((byte)decoration.getType().getId()), (byte)decoration.getPosition().getX(), (byte)decoration.getPosition().getY(), (byte)decoration.getRotation())).toArray(MapDecoration[]::new));
            fields[4].setInt(this.getHandler(), this.origin.getX());
            fields[5].setInt(this.getHandler(), this.origin.getY());
            fields[6].setInt(this.getHandler(), this.size.getX());
            fields[7].setInt(this.getHandler(), this.size.getY());
            fields[8].set(this.getHandler(), this.mapView.getColors());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void refresh() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            this.mapId = fields[0].getInt(this.getHandler());
            this.origin = new Vector2i(fields[4].getInt(this.getHandler()), fields[5].getInt(this.getHandler()));
            this.size = new Vector2i(fields[6].getInt(this.getHandler()), fields[7].getInt(this.getHandler()));
            byte[] colors = (byte[])fields[8].get(this.getHandler());
            if (colors.length == 16384) {
                this.mapView = new WSMapView((byte[])fields[8].get(this.getHandler()), Arrays.stream((MapDecoration[])fields[3].get(this.getHandler())).map(mapDecoration -> new WSMapDecoration(new Vector2i(mapDecoration.func_176112_b(), mapDecoration.func_176113_c()), EnumMapDecorationType.getById(mapDecoration.func_191179_b().func_191163_a()).orElse(EnumMapDecorationType.PLAYER), mapDecoration.func_176111_d())).collect(Collectors.toSet()), fields[2].getBoolean(this.getHandler()), EnumMapScale.getById(fields[1].getByte(this.getHandler())).orElse(EnumMapScale.CLOSEST));
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public int getMapId() {
        return this.mapId;
    }

    @Override
    public void setMapId(int id) {
        this.mapId = id;
        this.changed = true;
    }

    @Override
    public Vector2i getOrigin() {
        return this.origin;
    }

    @Override
    public void setOrigin(Vector2i origin) {
        this.origin = origin;
        this.changed = true;
    }

    @Override
    public Vector2i setSize() {
        return this.size;
    }

    @Override
    public void setSize(Vector2i size) {
        this.size = size;
        this.changed = true;
    }

    @Override
    public WSMapView getMapView() {
        this.changed = true;
        return this.mapView;
    }

    @Override
    public void setMapView(WSMapView mapView) {
        this.mapView = mapView;
        this.changed = true;
    }
}

