/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.packet.play.server;

import com.degoos.wetsponge.entity.living.WSLivingEntity;
import com.degoos.wetsponge.packet.SpongePacket;
import com.degoos.wetsponge.packet.play.server.WSSPacketEntityProperties;
import com.degoos.wetsponge.util.Validate;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityProperties;

public class SpongeSPacketEntityProperties
extends SpongePacket
implements WSSPacketEntityProperties {
    private int entityId;
    private List<SPacketEntityProperties.Snapshot> entries = new ArrayList<SPacketEntityProperties.Snapshot>();
    private boolean changed;

    public SpongeSPacketEntityProperties(WSLivingEntity entity) {
        super((Packet<?>)new SPacketEntityProperties(entity.getEntityId(), ((EntityLivingBase)entity.getHandled()).func_110140_aT().func_111146_a()));
        this.setPropertiesOf(entity);
        this.refresh();
    }

    public SpongeSPacketEntityProperties(Packet<?> packet) {
        super(packet);
        this.refresh();
    }

    @Override
    public int getEntityId() {
        return this.entityId;
    }

    @Override
    public void setEntityId(int entityId) {
        if (entityId != this.entityId) {
            this.entityId = entityId;
            this.changed = true;
        }
    }

    @Override
    public void setPropertiesOf(WSLivingEntity entity) {
        SPacketEntityProperties packet = (SPacketEntityProperties)this.getHandler();
        Validate.notNull(entity, "Entity cannot be null!");
        this.entries.clear();
        ((EntityLivingBase)entity.getHandled()).func_110140_aT().func_111146_a().forEach(attribute -> {
            SPacketEntityProperties sPacketEntityProperties = packet;
            sPacketEntityProperties.getClass();
            this.entries.add(new SPacketEntityProperties.Snapshot(sPacketEntityProperties, attribute.func_111123_a().func_111108_a(), attribute.func_111125_b(), attribute.func_111122_c()));
        });
        this.changed = true;
    }

    @Override
    public void update() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            fields[0].setInt(this.getHandler(), this.entityId);
            Collection snapshots = (Collection)fields[1].get(this.getHandler());
            snapshots.clear();
            snapshots.addAll(this.entries);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void refresh() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            this.entityId = fields[0].getInt(this.getHandler());
            Collection snapshots = (Collection)fields[1].get(this.getHandler());
            this.entries.clear();
            this.entries.addAll(snapshots);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }
}

