/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.packet.play.server;

import com.degoos.wetsponge.entity.SpigotEntity;
import com.degoos.wetsponge.entity.living.WSLivingEntity;
import com.degoos.wetsponge.packet.SpigotPacket;
import com.degoos.wetsponge.packet.play.server.WSSPacketEntityProperties;
import com.degoos.wetsponge.util.InternalLogger;
import com.degoos.wetsponge.util.Validate;
import com.degoos.wetsponge.util.reflection.NMSUtils;
import com.degoos.wetsponge.util.reflection.ReflectionUtils;
import com.degoos.wetsponge.util.reflection.SpigotHandledUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class SpigotSPacketEntityProperties
extends SpigotPacket
implements WSSPacketEntityProperties {
    private int entityId;
    private List<Object> entries = new ArrayList<Object>();
    private boolean changed;

    public SpigotSPacketEntityProperties(WSLivingEntity entity) throws IllegalAccessException, InstantiationException {
        super(NMSUtils.getNMSClass("PacketPlayOutUpdateAttributes").newInstance());
        this.setPropertiesOf(entity);
        this.refresh();
    }

    public SpigotSPacketEntityProperties(Object packet) {
        super(packet);
        this.refresh();
    }

    @Override
    public int getEntityId() {
        return this.entityId;
    }

    @Override
    public void setEntityId(int entityId) {
        if (entityId != this.entityId) {
            this.entityId = entityId;
            this.changed = true;
        }
    }

    @Override
    public void setPropertiesOf(WSLivingEntity entity) {
        Validate.notNull(entity, "Entity cannot be null!");
        this.entries.clear();
        try {
            Object entityHandle = SpigotHandledUtils.getEntityHandle(((SpigotEntity)((Object)entity)).getHandled());
            Object attributeMap = ReflectionUtils.invokeMethod(entityHandle, "getAttributeMap", new Object[0]);
            Collection attributes = (Collection)ReflectionUtils.invokeMethod(attributeMap, "a", new Object[0]);
            attributes.forEach(attribute -> {
                try {
                    Object iAttribute = ReflectionUtils.invokeMethod(attribute, "getAttribute", new Object[0]);
                    this.entries.add(this.getHandler().getClass().getDeclaredClasses()[0].getConstructors()[0].newInstance(this.getHandler(), ReflectionUtils.invokeMethod(iAttribute, "getName", new Object[0]), ReflectionUtils.invokeMethod(attribute, "b", new Object[0]), ReflectionUtils.invokeMethod(attribute, "c", new Object[0])));
                }
                catch (Exception ex) {
                    InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was setting the properties of a packet!");
                }
            });
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was setting the properties of a packet!");
        }
        this.changed = true;
    }

    @Override
    public void update() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            fields[0].setInt(this.getHandler(), this.entityId);
            Collection snapshots = (Collection)fields[1].get(this.getHandler());
            snapshots.clear();
            Method addMethod = ReflectionUtils.getMethodByName(List.class, "add");
            for (Object o : this.entries) {
                addMethod.invoke((Object)snapshots, o);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void refresh() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            this.entityId = fields[0].getInt(this.getHandler());
            List snapshots = (List)fields[1].get(this.getHandler());
            this.entries.clear();
            this.entries.addAll(snapshots);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }
}

