/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.packet.play.server;

import com.degoos.wetsponge.entity.living.WSLivingEntity;
import com.degoos.wetsponge.packet.SpigotPacket;
import com.degoos.wetsponge.packet.play.server.WSSPacketEntityHeadLook;
import com.degoos.wetsponge.util.reflection.NMSUtils;
import java.lang.reflect.Field;
import java.util.Arrays;

public class SpigotSPacketEntityHeadLook
extends SpigotPacket
implements WSSPacketEntityHeadLook {
    private int entityId;
    private int yaw;
    private boolean changed;

    public SpigotSPacketEntityHeadLook(int entityId, int yaw) throws IllegalAccessException, InstantiationException {
        super(NMSUtils.getNMSClass("PacketPlayOutEntityHeadRotation").newInstance());
        this.entityId = entityId;
        this.yaw = yaw;
        this.changed = false;
        this.update();
    }

    public SpigotSPacketEntityHeadLook(WSLivingEntity entity) throws InstantiationException, IllegalAccessException {
        this(entity.getEntityId(), entity.getHeadRotation().toInt().getY());
    }

    public SpigotSPacketEntityHeadLook(Object packet) {
        super(packet);
        this.refresh();
        this.changed = false;
    }

    @Override
    public int getEntityId() {
        return this.entityId;
    }

    @Override
    public void setEntityId(int entityId) {
        this.entityId = entityId;
        this.changed = true;
    }

    @Override
    public int getYaw() {
        return this.yaw;
    }

    @Override
    public void setYaw(int yaw) {
        this.yaw = yaw;
    }

    @Override
    public void update() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            fields[0].setInt(this.getHandler(), this.entityId);
            fields[1].setByte(this.getHandler(), (byte)((double)this.yaw * 256.0 / 360.0));
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void refresh() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            this.entityId = fields[0].getInt(this.getHandler());
            this.yaw = (int)((double)fields[1].getByte(this.getHandler()) * 360.0 / 256.0);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }
}

