/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.packet.play.server;

import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.enums.EnumEquipType;
import com.degoos.wetsponge.enums.EnumServerVersion;
import com.degoos.wetsponge.item.SpigotItemStack;
import com.degoos.wetsponge.item.WSItemStack;
import com.degoos.wetsponge.material.WSBlockTypes;
import com.degoos.wetsponge.packet.SpigotPacket;
import com.degoos.wetsponge.packet.play.server.WSSPacketEntityEquipment;
import com.degoos.wetsponge.util.Validate;
import com.degoos.wetsponge.util.reflection.NMSUtils;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.bukkit.inventory.ItemStack;

public class SpigotSPacketEntityEquipment
extends SpigotPacket
implements WSSPacketEntityEquipment {
    private int entityId;
    private EnumEquipType equipType;
    private WSItemStack itemStack;
    private boolean changed;

    public SpigotSPacketEntityEquipment(int entityId, EnumEquipType equipType, WSItemStack itemStack) throws IllegalAccessException, InstantiationException {
        super(NMSUtils.getNMSClass("PacketPlayOutEntityEquipment").newInstance());
        Validate.notNull((Object)equipType, "Equip type cannot be null!");
        this.entityId = entityId;
        this.equipType = equipType;
        this.itemStack = itemStack == null ? null : itemStack.clone();
        this.changed = false;
        this.update();
    }

    public SpigotSPacketEntityEquipment(Object packet) {
        super(packet);
        this.changed = false;
        this.refresh();
    }

    @Override
    public int getEntityId() {
        return this.entityId;
    }

    @Override
    public void setEntityId(int entityId) {
        this.entityId = entityId;
        this.changed = true;
    }

    @Override
    public EnumEquipType getEquipType() {
        return this.equipType;
    }

    @Override
    public void setEquipType(EnumEquipType equipType) {
        Validate.notNull((Object)equipType, "Equip type cannot be null!");
        this.equipType = equipType;
        this.changed = true;
    }

    @Override
    public WSItemStack getItemStack() {
        return this.itemStack.clone();
    }

    @Override
    public void setItemStack(WSItemStack itemStack) {
        this.itemStack = itemStack == null ? null : itemStack.clone();
        this.changed = true;
    }

    @Override
    public void update() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            fields[0].setInt(this.getHandler(), this.entityId);
            fields[2].set(this.getHandler(), NMSUtils.getOBCClass("inventory.CraftItemStack").getMethod("asNMSCopy", ItemStack.class).invoke(null, (ItemStack)(this.itemStack == null ? WSItemStack.of(WSBlockTypes.AIR).getHandled() : this.itemStack.getHandled())));
            if (WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD)) {
                fields[1].set(this.getHandler(), Enum.valueOf(NMSUtils.getNMSClass("EnumItemSlot"), this.equipType.getMinecraftName()));
            } else {
                fields[1].setInt(this.getHandler(), this.equipType == EnumEquipType.MAIN_HAND ? 0 : this.equipType.getValue() - 1);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void refresh() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            this.entityId = fields[0].getInt(this.getHandler());
            this.itemStack = new SpigotItemStack((ItemStack)NMSUtils.getOBCClass("inventory.CraftItemStack").getMethod("asBukkitCopy", NMSUtils.getNMSClass("ItemStack")).invoke(null, fields[2].get(this.getHandler())));
            this.equipType = WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD) ? EnumEquipType.getByMinecraftName(((Enum)fields[1].get(this.getHandler())).name()).orElse(EnumEquipType.MAIN_HAND) : EnumEquipType.getByValue(Math.max(0, fields[1].getInt(this.getHandler()) - 1)).orElse(EnumEquipType.MAIN_HAND);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }
}

