/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.packet.play.server;

import com.degoos.wetsponge.material.WSBlockTypes;
import com.degoos.wetsponge.material.block.WSBlockType;
import com.degoos.wetsponge.packet.SpigotPacket;
import com.degoos.wetsponge.packet.play.server.WSSPacketBlockChange;
import com.degoos.wetsponge.util.reflection.NMSUtils;
import com.degoos.wetsponge.util.reflection.ReflectionUtils;
import com.degoos.wetsponge.util.reflection.SpigotHandledUtils;
import com.flowpowered.math.vector.Vector3i;

public class SpigotSPacketBlockChange
extends SpigotPacket
implements WSSPacketBlockChange {
    private WSBlockType material;
    private Vector3i position;
    private boolean changed;

    public SpigotSPacketBlockChange(WSBlockType type, Vector3i position) throws IllegalAccessException, InstantiationException {
        super(NMSUtils.getNMSClass("PacketPlayOutBlockChange").newInstance());
        this.position = position;
        this.material = type.clone();
        this.update();
    }

    public SpigotSPacketBlockChange(Object packet) {
        super(packet);
        this.refresh();
    }

    @Override
    public void update() {
        try {
            Object state = SpigotHandledUtils.getBlockState(this.material);
            ReflectionUtils.setFirstObject(this.getHandler().getClass(), NMSUtils.getNMSClass("BlockPosition"), this.getHandler(), SpigotHandledUtils.getBlockPosition(this.position));
            ReflectionUtils.setFirstObject(this.getHandler().getClass(), NMSUtils.getNMSClass("IBlockData"), this.getHandler(), state);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void refresh() {
        try {
            this.material = SpigotHandledUtils.getMaterial(ReflectionUtils.getFirstObject(this.getHandler().getClass(), NMSUtils.getNMSClass("IBlockData"), this.getHandler()));
            this.position = SpigotHandledUtils.getBlockPositionVector(ReflectionUtils.getFirstObject(this.getHandler().getClass(), NMSUtils.getNMSClass("BlockPosition"), this.getHandler()));
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            this.material = WSBlockTypes.AIR.getDefaultState();
            this.position = new Vector3i(0, 0, 0);
        }
    }

    @Override
    public Vector3i getBlockPosition() {
        return this.position;
    }

    @Override
    public void setBlockPosition(Vector3i position) {
        this.position = position;
        this.changed = true;
    }

    @Override
    public WSBlockType getMaterial() {
        this.changed = true;
        return this.material;
    }

    @Override
    public void setMaterial(WSBlockType material) {
        this.material = material;
        this.changed = true;
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }
}

