/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.packet.play.server;

import com.degoos.wetsponge.entity.living.player.WSHuman;
import com.degoos.wetsponge.packet.Spigot13Packet;
import com.degoos.wetsponge.packet.play.server.WSSPacketUseBed;
import com.degoos.wetsponge.util.InternalLogger;
import com.degoos.wetsponge.util.reflection.NMSUtils;
import com.degoos.wetsponge.util.reflection.Spigot13HandledUtils;
import com.flowpowered.math.vector.Vector3i;
import java.lang.reflect.Field;
import java.util.Arrays;

public class Spigot13SPacketUseBed
extends Spigot13Packet
implements WSSPacketUseBed {
    private int entityId;
    private Vector3i position;
    private boolean changed;

    public Spigot13SPacketUseBed(int entityId, Vector3i position) throws IllegalAccessException, InstantiationException {
        super(NMSUtils.getNMSClass("PacketPlayOutBed").newInstance());
        this.position = position;
        this.entityId = entityId;
        this.update();
    }

    public Spigot13SPacketUseBed(WSHuman human, Vector3i position) throws IllegalAccessException, InstantiationException {
        super(NMSUtils.getNMSClass("PacketPlayOutBed").newInstance());
        this.position = position;
        this.entityId = human.getEntityId();
        this.update();
    }

    public Spigot13SPacketUseBed(Object packet) {
        super(packet);
        this.refresh();
    }

    @Override
    public void update() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            fields[0].setInt(this.getHandler(), this.entityId);
            fields[1].set(this.getHandler(), Spigot13HandledUtils.getBlockPosition(this.position));
        }
        catch (Throwable ex) {
            InternalLogger.printException(ex, "An error has occurred while WetSponge was updating a packet!");
        }
    }

    @Override
    public void refresh() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            this.entityId = fields[0].getInt(this.getHandler());
            this.position = Spigot13HandledUtils.getBlockPositionVector(fields[1].get(this.getHandler()));
        }
        catch (Throwable ex) {
            InternalLogger.printException(ex, "An error has occurred while WetSponge was refreshing a packet!");
            this.entityId = 0;
            this.position = new Vector3i(0, 0, 0);
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public int getEntityId() {
        return this.entityId;
    }

    @Override
    public void setEntityId(int entityId) {
        this.entityId = entityId;
    }

    @Override
    public Vector3i getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Vector3i position) {
        this.position = position;
        this.changed = true;
    }
}

