/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.packet.play.server;

import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.entity.living.Spigot13LivingEntity;
import com.degoos.wetsponge.entity.living.WSLivingEntity;
import com.degoos.wetsponge.entity.living.player.Spigot13Human;
import com.degoos.wetsponge.entity.living.player.WSHuman;
import com.degoos.wetsponge.enums.EnumEquipType;
import com.degoos.wetsponge.enums.EnumServerVersion;
import com.degoos.wetsponge.packet.Spigot13Packet;
import com.degoos.wetsponge.packet.play.server.WSSPacketSpawnPlayer;
import com.degoos.wetsponge.util.Validate;
import com.degoos.wetsponge.util.reflection.NMSUtils;
import com.degoos.wetsponge.util.reflection.ReflectionUtils;
import com.degoos.wetsponge.util.reflection.Spigot13HandledUtils;
import com.degoos.wetsponge.world.WSLocation;
import com.flowpowered.math.vector.Vector2d;
import com.flowpowered.math.vector.Vector3d;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.LivingEntity;

public class Spigot13SPacketSpawnPlayer
extends Spigot13Packet
implements WSSPacketSpawnPlayer {
    private Optional<WSLivingEntity> entity;
    private int entityId;
    private UUID uniqueId;
    private Vector3d position;
    private Vector2d rotation;
    private int itemId;
    private boolean changed;

    public Spigot13SPacketSpawnPlayer(WSHuman entity) throws IllegalAccessException, InstantiationException {
        super(NMSUtils.getNMSClass("PacketPlayOutNamedEntitySpawn").newInstance());
        this.updateEntity(entity);
        WSLocation location = entity.getLocation();
        this.position = location.toVector3d();
        this.rotation = location.getRotation().toDouble();
        this.update();
    }

    public Spigot13SPacketSpawnPlayer(WSHuman entity, Vector3d position, Vector2d rotation) throws IllegalAccessException, InstantiationException {
        super(NMSUtils.getNMSClass("PacketPlayOutNamedEntitySpawn").newInstance());
        this.updateEntity(entity);
        this.position = position;
        this.rotation = rotation;
        this.update();
    }

    public Spigot13SPacketSpawnPlayer(Object packet) {
        super(packet);
        this.entity = Optional.empty();
        this.refresh();
    }

    public Optional<WSLivingEntity> getEntity() {
        return this.entity;
    }

    @Override
    public void setEntity(WSHuman entity) {
        Validate.notNull(entity, "Entity cannot be null!");
        this.updateEntity(entity);
    }

    @Override
    public int getEntityId() {
        return this.entityId;
    }

    @Override
    public void setEntityId(int entityId) {
        this.changed = true;
        this.entityId = entityId;
    }

    @Override
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public void setUniqueId(UUID uniqueId) {
        this.changed = true;
        this.uniqueId = uniqueId;
    }

    @Override
    public Vector3d getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Vector3d position) {
        this.changed = true;
        this.position = position;
    }

    @Override
    public Vector2d getRotation() {
        return this.rotation;
    }

    @Override
    public void setRotation(Vector2d rotation) {
        this.changed = true;
        this.rotation = rotation;
    }

    private void updateEntity(WSHuman entity) {
        HumanEntity spigotEntity = ((Spigot13Human)entity).getHandled();
        Object handle = Spigot13HandledUtils.getHandle(spigotEntity);
        this.entity = Optional.ofNullable(entity);
        this.entityId = entity.getEntityId();
        this.uniqueId = spigotEntity.getUniqueId();
        try {
            Object inventory = handle.getClass().getField("inventory").get(handle);
            Object itemStack = ReflectionUtils.getMethod(inventory.getClass(), "getItemInHand", new Class[0]).invoke(inventory, new Object[0]);
            Object item = ReflectionUtils.getMethod(itemStack.getClass(), "getItem", new Class[0]).invoke(itemStack, new Object[0]);
            this.itemId = entity.getEquippedItem(EnumEquipType.MAIN_HAND).map(target -> target.getMaterial().getNumericalId()).orElse(0);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void update() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            fields[0].setInt(this.getHandler(), this.entityId);
            fields[1].set(this.getHandler(), this.uniqueId);
            if (WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD)) {
                fields[2].setDouble(this.getHandler(), this.position.getX());
                fields[3].setDouble(this.getHandler(), this.position.getY());
                fields[4].setDouble(this.getHandler(), this.position.getZ());
            } else {
                fields[2].setInt(this.getHandler(), (int)this.position.getX() * 32);
                fields[3].setInt(this.getHandler(), (int)this.position.getY() * 32);
                fields[4].setInt(this.getHandler(), (int)this.position.getZ() * 32);
                fields[7].setInt(this.getHandler(), this.itemId);
            }
            fields[5].setByte(this.getHandler(), (byte)(this.rotation.getX() * 256.0 / 360.0));
            fields[6].setByte(this.getHandler(), (byte)(this.rotation.getY() * 256.0 / 360.0));
            if (this.entity.isPresent()) {
                LivingEntity spigotEntity = ((Spigot13LivingEntity)this.entity.get()).getHandled();
                Object livingBase = Spigot13HandledUtils.getEntityHandle((Entity)spigotEntity);
                fields[WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD) ? 7 : 8].set(this.getHandler(), ReflectionUtils.getMethod(livingBase.getClass(), "getDataWatcher", new Class[0]).invoke(livingBase, new Object[0]));
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void refresh() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            this.entityId = fields[0].getInt(this.getHandler());
            this.uniqueId = (UUID)fields[1].get(this.getHandler());
            this.position = new Vector3d(fields[2].getDouble(this.getHandler()), fields[3].getDouble(this.getHandler()), fields[4].getDouble(this.getHandler()));
            this.rotation = new Vector2d((double)fields[5].getByte(this.getHandler()) * 360.0 / 256.0, (double)fields[6].getByte(this.getHandler()) * 360.0 / 256.0);
            if (WetSponge.getVersion().isOlderThan(EnumServerVersion.MINECRAFT_1_9)) {
                this.itemId = fields[7].getInt(this.getHandler());
            }
            this.entity = Optional.empty();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }
}

