/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.packet.play.server;

import com.degoos.wetsponge.packet.Spigot13Packet;
import com.degoos.wetsponge.packet.play.server.WSSPacketServerInfo;
import com.degoos.wetsponge.server.response.WSServerStatusResponse;
import com.degoos.wetsponge.server.response.WSStatusPlayers;
import com.degoos.wetsponge.server.response.WSStatusVersion;
import com.degoos.wetsponge.text.Spigot13Text;
import com.degoos.wetsponge.text.WSText;
import com.degoos.wetsponge.user.Spigot13GameProfile;
import com.degoos.wetsponge.user.WSGameProfile;
import com.degoos.wetsponge.util.ListUtils;
import com.degoos.wetsponge.util.Validate;
import com.degoos.wetsponge.util.reflection.NMSUtils;
import com.degoos.wetsponge.util.reflection.ReflectionUtils;
import com.degoos.wetsponge.util.reflection.Spigot13TextUtils;
import com.mojang.authlib.GameProfile;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.chat.ComponentSerializer;

public class Spigot13SPacketServerInfo
extends Spigot13Packet
implements WSSPacketServerInfo {
    private WSServerStatusResponse response;
    private boolean changed;

    public Spigot13SPacketServerInfo(WSServerStatusResponse response) {
        super(NMSUtils.getNMSClass("PacketStatusOutServerInfo"));
        Validate.notNull(response, "Response cannot be null!");
        this.response = response;
        this.changed = false;
        this.update();
    }

    public Spigot13SPacketServerInfo(Object packet) {
        super(packet);
        this.changed = false;
        this.refresh();
    }

    @Override
    public void update() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            Class<?> responseClass = NMSUtils.getNMSClass("ServerPing");
            Class<?> versionClass = NMSUtils.getNMSClass("ServerPing$ServerData");
            Class<?> playersClass = NMSUtils.getNMSClass("ServerPing$ServerPingPlayerSample");
            Object nmsResponse = ReflectionUtils.instantiateObject(responseClass, new Object[0]);
            Object version = ReflectionUtils.instantiateObject(versionClass, this.response.getVersion().getName(), this.response.getVersion().getProtocol());
            Object players = ReflectionUtils.instantiateObject(playersClass, this.response.getPlayers().getMaxPlayers(), this.response.getPlayers().getPlayerCount());
            ReflectionUtils.invokeMethod(nmsResponse, "setFavicon", this.response.getFaviconString());
            ReflectionUtils.invokeMethod(nmsResponse, "setMOTD", Spigot13TextUtils.toJSON(ComponentSerializer.toString((BaseComponent)((BaseComponent)this.response.getMOTD().getHandled()))));
            GameProfile[] profiles = ListUtils.toArray(GameProfile.class, this.response.getPlayers().getProfiles().stream().map(profile -> (GameProfile)profile.getHandled()).collect(Collectors.toList()));
            ReflectionUtils.invokeMethod(players, "a", new Object[]{profiles});
            ReflectionUtils.invokeMethod(nmsResponse, "setPlayerSample", players);
            ReflectionUtils.invokeMethod(nmsResponse, "setServerInfo", version);
            fields[1].set(this.getHandler(), nmsResponse);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void refresh() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            Class<?> responseClass = NMSUtils.getNMSClass("ServerPing");
            Class<?> versionClass = NMSUtils.getNMSClass("ServerPing$ServerData");
            Class<?> playersClass = NMSUtils.getNMSClass("ServerPing$ServerPingPlayerSample");
            Field[] responseFields = responseClass.getClass().getDeclaredFields();
            Arrays.stream(responseFields).forEach(field -> field.setAccessible(true));
            Object nmsResponse = fields[1].get(this.getHandler());
            Object nmsMotd = responseFields[0].get(nmsResponse);
            Object nmsPlayers = responseFields[1].get(nmsResponse);
            Object nmsVersion = responseFields[2].get(nmsResponse);
            String favicon = (String)responseFields[3].get(nmsResponse);
            Spigot13Text motd = Spigot13Text.of((BaseComponent)new TextComponent(ComponentSerializer.parse((String)Spigot13TextUtils.toJSON(nmsMotd))));
            Field[] playerFields = playersClass.getClass().getDeclaredFields();
            Arrays.stream(playerFields).forEach(field -> field.setAccessible(true));
            Field[] versionFields = versionClass.getClass().getDeclaredFields();
            Arrays.stream(versionFields).forEach(field -> field.setAccessible(true));
            Set<WSGameProfile> profiles = ListUtils.toSet((GameProfile[])playerFields[2].get(nmsPlayers)).stream().map(Spigot13GameProfile::new).collect(Collectors.toSet());
            this.response = new WSServerStatusResponse((WSText)motd, favicon, new WSStatusPlayers(playerFields[0].getInt(nmsPlayers), playerFields[1].getInt(nmsPlayers), profiles), new WSStatusVersion((String)versionFields[0].get(nmsVersion), versionFields[1].getInt(nmsVersion)));
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed || this.response.hasChanged();
    }

    @Override
    public WSServerStatusResponse getResponse() {
        return this.response;
    }

    @Override
    public void setResponse(WSServerStatusResponse response) {
        this.response = response;
        this.changed = true;
    }
}

