/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.packet.play.server;

import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.enums.EnumGameMode;
import com.degoos.wetsponge.enums.EnumPlayerListItemAction;
import com.degoos.wetsponge.enums.EnumServerVersion;
import com.degoos.wetsponge.packet.Spigot13Packet;
import com.degoos.wetsponge.packet.play.server.WSSPacketPlayerListItem;
import com.degoos.wetsponge.packet.play.server.extra.WSPlayerListItemData;
import com.degoos.wetsponge.text.Spigot13Text;
import com.degoos.wetsponge.user.Spigot13GameProfile;
import com.degoos.wetsponge.util.ListUtils;
import com.degoos.wetsponge.util.reflection.NMSUtils;
import com.degoos.wetsponge.util.reflection.Spigot13TextUtils;
import com.mojang.authlib.GameProfile;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.chat.ComponentSerializer;

public class Spigot13SPacketPlayerListItem
extends Spigot13Packet
implements WSSPacketPlayerListItem {
    private boolean changed = false;
    private EnumPlayerListItemAction action;
    private List<WSPlayerListItemData> data;

    public Spigot13SPacketPlayerListItem(EnumPlayerListItemAction action, Collection<WSPlayerListItemData> itemData) throws IllegalAccessException, InstantiationException {
        super(NMSUtils.getNMSClass("PacketPlayOutPlayerInfo").newInstance());
        this.action = action;
        this.data = new ArrayList<WSPlayerListItemData>(itemData);
        this.update();
    }

    public Spigot13SPacketPlayerListItem(EnumPlayerListItemAction action, WSPlayerListItemData ... itemData) throws IllegalAccessException, InstantiationException {
        super(NMSUtils.getNMSClass("PacketPlayOutPlayerInfo").newInstance());
        this.action = action;
        this.data = ListUtils.toList(itemData);
        this.update();
    }

    public Spigot13SPacketPlayerListItem(Object packet) {
        super(packet);
        this.data = new ArrayList<WSPlayerListItemData>();
        this.refresh();
    }

    @Override
    public void update() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            Class<?> enumClass = NMSUtils.getNMSClass("PacketPlayOutPlayerInfo$EnumPlayerInfoAction");
            Class<?> gameModeClass = NMSUtils.getNMSClass(WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD) ? "EnumGamemode" : "WorldSettings$EnumGamemode");
            Class<?> iChatBaseClass = NMSUtils.getNMSClass("IChatBaseComponent");
            Class<?> dataClass = NMSUtils.getNMSClass("PacketPlayOutPlayerInfo$PlayerInfoData");
            Constructor<?> dataConstructor = dataClass.getConstructor(this.getHandler().getClass(), GameProfile.class, Integer.TYPE, gameModeClass, iChatBaseClass);
            fields[0].set(this.getHandler(), Enum.valueOf(enumClass, this.action.name()));
            List list = (List)fields[1].get(this.getHandler());
            list.clear();
            for (WSPlayerListItemData itemData : this.data) {
                list.add(dataConstructor.newInstance(this.getHandler(), itemData.getGameProfile().getHandled(), itemData.getPing(), Enum.valueOf(gameModeClass, itemData.getGameMode() == null ? "NOT_SET" : itemData.getGameMode().name()), itemData.getDisplayName() == null ? null : Spigot13TextUtils.toIChatBaseComponentFromFormattedText(itemData.getDisplayName().toFormattingText())));
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void refresh() {
        try {
            this.data.clear();
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            this.action = EnumPlayerListItemAction.valueOf(((Enum)fields[0].get(this.getHandler())).name());
            List list = (List)fields[1].get(this.getHandler());
            for (Object itemData : list) {
                GameProfile gameProfile = (GameProfile)itemData.getClass().getMethod("a", new Class[0]).invoke(itemData, new Object[0]);
                int ping = (Integer)itemData.getClass().getMethod("b", new Class[0]).invoke(itemData, new Object[0]);
                Enum en = (Enum)itemData.getClass().getMethod("c", new Class[0]).invoke(itemData, new Object[0]);
                EnumGameMode gameMode = en == null || en.name().equals("NOT_SET") ? null : EnumGameMode.valueOf(en.name());
                Object d = itemData.getClass().getMethod("d", new Class[0]).invoke(itemData, new Object[0]);
                Spigot13Text displayName = d == null ? null : Spigot13Text.of((BaseComponent)new TextComponent(ComponentSerializer.parse((String)Spigot13TextUtils.toJSON(d))));
                this.data.add(new WSPlayerListItemData(ping, gameMode, new Spigot13GameProfile(gameProfile), displayName));
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public EnumPlayerListItemAction getAction() {
        return this.action;
    }

    @Override
    public void setAction(EnumPlayerListItemAction action) {
        this.action = action;
        this.changed = true;
    }

    @Override
    public List<WSPlayerListItemData> getData() {
        this.changed = true;
        return this.data;
    }
}

