/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.packet.play.server;

import com.degoos.wetsponge.packet.Spigot13Packet;
import com.degoos.wetsponge.packet.play.server.WSSPacketDestroyEntities;
import com.degoos.wetsponge.util.reflection.NMSUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Spigot13SPacketDestroyEntities
extends Spigot13Packet
implements WSSPacketDestroyEntities {
    private List<Integer> entityIds = new ArrayList<Integer>();
    private boolean changed;

    public Spigot13SPacketDestroyEntities(int ... entities) throws IllegalAccessException, InstantiationException {
        super(NMSUtils.getNMSClass("PacketPlayOutEntityDestroy").newInstance());
        for (int i : entities) {
            this.entityIds.add(i);
        }
        this.update();
    }

    public Spigot13SPacketDestroyEntities(Object packet) {
        super(packet);
        this.refresh();
    }

    @Override
    public void update() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            int[] ids = new int[this.entityIds.size()];
            for (int i = 0; i < this.entityIds.size(); ++i) {
                ids[i] = this.entityIds.get(i);
            }
            fields[0].set(this.getHandler(), ids);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void refresh() {
        try {
            int[] ids;
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            this.entityIds.clear();
            for (int i : ids = (int[])fields[0].get(this.getHandler())) {
                this.entityIds.add(i);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public List<Integer> getEntityIds() {
        this.changed = true;
        return this.entityIds;
    }

    @Override
    public void setEntityIds(List<Integer> entityIds) {
        this.changed = true;
        this.entityIds = entityIds;
    }

    @Override
    public void addEntityId(int entityId) {
        this.changed = true;
        this.entityIds.add(entityId);
    }

    @Override
    public void removeEntityId(int entityId) {
        this.changed = true;
        this.entityIds.add(entityId);
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }
}

