/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.packet.play.client;

import com.degoos.wetsponge.enums.EnumUseEntityType;
import com.degoos.wetsponge.packet.SpongePacket;
import com.degoos.wetsponge.packet.play.client.WSCPacketUseEntity;
import com.degoos.wetsponge.util.Validate;
import com.flowpowered.math.vector.Vector3d;
import java.lang.reflect.Field;
import java.util.Arrays;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketUseEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;

public class SpongeCPacketUseEntity
extends SpongePacket
implements WSCPacketUseEntity {
    private int target;
    private EnumUseEntityType type;
    private Vector3d interactAtPosition;
    private boolean mainHand;
    private boolean changed;

    public SpongeCPacketUseEntity(int target, EnumUseEntityType type, Vector3d interactAtPosition, boolean mainHand) {
        super((Packet<?>)new CPacketUseEntity());
        this.target = target;
        this.type = type;
        this.interactAtPosition = interactAtPosition;
        this.mainHand = mainHand;
        this.update();
    }

    public SpongeCPacketUseEntity(Packet<?> packet) {
        super(packet);
        this.refresh();
    }

    @Override
    public int getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(int target) {
        if (this.target != target) {
            this.target = target;
            this.changed = true;
        }
    }

    @Override
    public EnumUseEntityType getType() {
        return this.type;
    }

    @Override
    public void setType(EnumUseEntityType type) {
        Validate.notNull((Object)type, "Type cannot be null!");
        if (this.type != type) {
            this.type = type;
            this.changed = true;
        }
    }

    @Override
    public Vector3d getInteractAtPosition() {
        return this.interactAtPosition == null ? new Vector3d() : this.interactAtPosition;
    }

    @Override
    public void setInteractAtPosition(Vector3d interactAtPosition) {
        if (!this.interactAtPosition.equals(interactAtPosition)) {
            this.interactAtPosition = interactAtPosition;
            this.changed = true;
        }
    }

    @Override
    public boolean isMainHand() {
        return this.mainHand;
    }

    @Override
    public void setMainHand(boolean mainHand) {
        if (mainHand != this.mainHand) {
            this.mainHand = mainHand;
            this.changed = true;
        }
    }

    @Override
    public void update() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            fields[0].setInt(this.getHandler(), this.target);
            fields[1].set(this.getHandler(), CPacketUseEntity.Action.valueOf((String)this.type.name()));
            if (this.interactAtPosition != null) {
                fields[2].set(this.getHandler(), new Vec3d(this.interactAtPosition.getX(), this.interactAtPosition.getY(), this.interactAtPosition.getZ()));
            }
            fields[3].set(this.getHandler(), this.mainHand ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void refresh() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            this.target = fields[0].getInt(this.getHandler());
            this.type = EnumUseEntityType.valueOf(((CPacketUseEntity.Action)fields[1].get(this.getHandler())).name());
            Vec3d vec3d = (Vec3d)fields[2].get(this.getHandler());
            if (vec3d != null) {
                this.interactAtPosition = new Vector3d(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
            }
            this.mainHand = EnumHand.MAIN_HAND.equals(fields[3].get(this.getHandler()));
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }
}

