/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.packet.play.client;

import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.enums.EnumServerVersion;
import com.degoos.wetsponge.enums.EnumUseEntityType;
import com.degoos.wetsponge.packet.SpigotPacket;
import com.degoos.wetsponge.packet.play.client.WSCPacketUseEntity;
import com.degoos.wetsponge.util.Validate;
import com.degoos.wetsponge.util.reflection.NMSUtils;
import com.flowpowered.math.vector.Vector3d;
import java.lang.reflect.Field;
import java.util.Arrays;

public class SpigotCPacketUseEntity
extends SpigotPacket
implements WSCPacketUseEntity {
    private int target;
    private EnumUseEntityType type;
    private Vector3d interactAtPosition;
    private boolean mainHand;
    private boolean changed;

    public SpigotCPacketUseEntity(int target, EnumUseEntityType type, Vector3d interactAtPosition, boolean mainHand) throws IllegalAccessException, InstantiationException {
        super(NMSUtils.getNMSClass("PacketPlayInUseEntity").newInstance());
        this.target = target;
        this.type = type;
        this.interactAtPosition = interactAtPosition;
        this.mainHand = mainHand;
        this.update();
    }

    public SpigotCPacketUseEntity(Object packet) {
        super(packet);
        this.refresh();
    }

    @Override
    public int getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(int target) {
        if (this.target != target) {
            this.target = target;
            this.changed = true;
        }
    }

    @Override
    public EnumUseEntityType getType() {
        return this.type;
    }

    @Override
    public void setType(EnumUseEntityType type) {
        Validate.notNull((Object)type, "Type cannot be null!");
        if (this.type != type) {
            this.type = type;
            this.changed = true;
        }
    }

    @Override
    public Vector3d getInteractAtPosition() {
        return this.interactAtPosition == null ? new Vector3d() : this.interactAtPosition;
    }

    @Override
    public void setInteractAtPosition(Vector3d interactAtPosition) {
        if (!this.interactAtPosition.equals(interactAtPosition)) {
            this.interactAtPosition = interactAtPosition;
            this.changed = true;
        }
    }

    @Override
    public boolean isMainHand() {
        return this.mainHand;
    }

    @Override
    public void setMainHand(boolean mainHand) {
        if (mainHand != this.mainHand) {
            this.mainHand = mainHand;
            this.changed = true;
        }
    }

    @Override
    public void update() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            Class<?> typeClass = NMSUtils.getNMSClass("PacketPlayInUseEntity$EnumEntityUseAction");
            Class<?> handClass = NMSUtils.getNMSClass("EnumHand");
            fields[0].setInt(this.getHandler(), this.target);
            fields[1].set(this.getHandler(), Enum.valueOf(typeClass, this.type.name()));
            if (this.interactAtPosition != null) {
                fields[2].set(this.getHandler(), NMSUtils.getNMSClass("Vec3D").getConstructor(Double.TYPE, Double.TYPE, Double.TYPE).newInstance(this.interactAtPosition.getX(), this.interactAtPosition.getY(), this.interactAtPosition.getZ()));
            }
            if (WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD)) {
                fields[3].set(this.getHandler(), Enum.valueOf(handClass, this.mainHand ? "MAIN_HAND" : "OFF_HAND"));
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void refresh() {
        try {
            boolean old;
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            this.target = fields[0].getInt(this.getHandler());
            this.type = EnumUseEntityType.valueOf(((Enum)fields[1].get(this.getHandler())).name());
            Object vec3d = fields[2].get(this.getHandler());
            boolean bl = old = !WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD);
            if (vec3d != null) {
                this.interactAtPosition = new Vector3d(NMSUtils.getNMSClass("Vec3D").getField(old ? "a" : "x").getDouble(vec3d), vec3d.getClass().getField(old ? "b" : "y").getDouble(vec3d), vec3d.getClass().getField(old ? "c" : "z").getDouble(vec3d));
            }
            if (WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD)) {
                Object object = fields[3].get(this.getHandler());
                this.mainHand = object == null || ((Enum)object).name().equals("MAIN_HAND");
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }
}

