/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.packet.play.client;

import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.enums.EnumEntityAction;
import com.degoos.wetsponge.enums.EnumServerVersion;
import com.degoos.wetsponge.packet.Spigot13Packet;
import com.degoos.wetsponge.packet.play.client.WSCPacketEntityAction;
import com.degoos.wetsponge.util.reflection.NMSUtils;
import java.lang.reflect.Field;
import java.util.Arrays;

public class Spigot13CPacketEntityAction
extends Spigot13Packet
implements WSCPacketEntityAction {
    private boolean changed;
    private int entityId;
    private int jumpBoost;
    private EnumEntityAction entityAction;

    public Spigot13CPacketEntityAction(int entityId, EnumEntityAction entityAction, int jumpBoost) throws IllegalAccessException, InstantiationException {
        super(NMSUtils.getNMSClass("PacketPlayInEntityAction").newInstance());
        this.entityId = entityId;
        this.entityAction = entityAction;
        this.jumpBoost = jumpBoost;
        this.update();
    }

    public Spigot13CPacketEntityAction(Object packet) {
        super(packet);
        this.refresh();
    }

    @Override
    public void update() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            fields[0].setInt(this.getHandler(), this.entityId);
            fields[2].setInt(this.getHandler(), this.jumpBoost);
            if (this.entityAction != null) {
                fields[1].set(this.getHandler(), Enum.valueOf(NMSUtils.getNMSClass("PacketPlayInEntityAction$EnumPlayerAction"), WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD) ? this.entityAction.name() : this.entityAction.getOldSpigotName()));
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void refresh() {
        try {
            Field[] fields = this.getHandler().getClass().getDeclaredFields();
            Arrays.stream(fields).forEach(field -> field.setAccessible(true));
            this.entityId = fields[0].getInt(this.getHandler());
            this.entityAction = EnumEntityAction.getById(((Enum)fields[1].get(this.getHandler())).ordinal()).orElse(null);
            this.jumpBoost = fields[2].getInt(this.getHandler());
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public int getEntityId() {
        return this.entityId;
    }

    @Override
    public void setEntityId(int entityId) {
        this.entityId = entityId;
        this.changed = true;
    }

    @Override
    public EnumEntityAction getAction() {
        return this.entityAction;
    }

    @Override
    public void setAction(EnumEntityAction entityAction) {
        this.entityAction = entityAction;
        this.changed = true;
    }

    @Override
    public int getJumpBoost() {
        return this.jumpBoost;
    }

    @Override
    public void setJumpBoost(int jumpBoost) {
        this.jumpBoost = jumpBoost;
        this.changed = true;
    }
}

