/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.nbt;

import com.degoos.wetsponge.nbt.SpigotNBTBase;
import com.degoos.wetsponge.nbt.WSNBTTagShort;
import com.degoos.wetsponge.util.InternalLogger;
import com.degoos.wetsponge.util.reflection.NMSUtils;
import com.degoos.wetsponge.util.reflection.ReflectionUtils;
import java.lang.reflect.InvocationTargetException;

public class SpigotNBTTagShort
extends SpigotNBTBase
implements WSNBTTagShort {
    private static final Class<?> clazz = NMSUtils.getNMSClass("NBTTagShort");

    public SpigotNBTTagShort(short s2) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        this(clazz.getConstructor(Short.TYPE).newInstance(s2));
    }

    public SpigotNBTTagShort(Object object) {
        super(object);
    }

    private short getValue() {
        try {
            return ReflectionUtils.getFirstObject(clazz, Short.TYPE, this.getHandled());
        }
        catch (Exception e) {
            InternalLogger.printException((Throwable)e, "An error has occurred while WetSponge was getting the value of a NBTTag!");
            return 0;
        }
    }

    @Override
    public long getLong() {
        return this.getValue();
    }

    @Override
    public int getInt() {
        return this.getValue();
    }

    @Override
    public short getShort() {
        return this.getValue();
    }

    @Override
    public byte getByte() {
        return (byte)(this.getValue() & 0xFF);
    }

    @Override
    public double getDouble() {
        return this.getValue();
    }

    @Override
    public float getFloat() {
        return this.getValue();
    }

    @Override
    public WSNBTTagShort copy() {
        try {
            return new SpigotNBTTagShort(this.getValue());
        }
        catch (Exception e) {
            InternalLogger.printException((Throwable)e, "An error has occurred while WetSponge was copying a NBTTag!");
            return null;
        }
    }

    @Override
    public Object getHandled() {
        return super.getHandled();
    }
}

