/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.nbt;

import com.degoos.wetsponge.nbt.SpigotNBTBase;
import com.degoos.wetsponge.nbt.WSNBTTagLongArray;
import com.degoos.wetsponge.util.InternalLogger;
import com.degoos.wetsponge.util.reflection.NMSUtils;
import com.degoos.wetsponge.util.reflection.ReflectionUtils;
import java.lang.reflect.InvocationTargetException;

public class SpigotNBTTagLongArray
extends SpigotNBTBase
implements WSNBTTagLongArray {
    private static final Class<?> clazz = NMSUtils.getNMSClass("NBTTagLongArray");

    public SpigotNBTTagLongArray(long[] longs) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        this(clazz.getConstructor(long[].class).newInstance(new Object[]{longs}));
    }

    public SpigotNBTTagLongArray(Object nbtTagByteArray) {
        super(nbtTagByteArray);
    }

    @Override
    public long[] getLongArray() {
        try {
            return ReflectionUtils.getFirstObject(clazz, long[].class, this.getHandled());
        }
        catch (Exception e) {
            InternalLogger.printException((Throwable)e, "An error has occurred while WetSponge was getting the value of a NBTTag!");
            return new long[0];
        }
    }

    @Override
    public WSNBTTagLongArray copy() {
        try {
            long[] values = this.getLongArray();
            long[] var1 = new long[values.length];
            System.arraycopy(values, 0, var1, 0, values.length);
            return new SpigotNBTTagLongArray(var1);
        }
        catch (Exception e) {
            InternalLogger.printException((Throwable)e, "An exception has occurred while WetSponge was cloning a NBTTag!");
            return null;
        }
    }

    @Override
    public Object getHandled() {
        return super.getHandled();
    }
}

