/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.nbt;

import com.degoos.wetsponge.nbt.SpigotNBTBase;
import com.degoos.wetsponge.nbt.WSNBTTagLong;
import com.degoos.wetsponge.util.InternalLogger;
import com.degoos.wetsponge.util.reflection.NMSUtils;
import com.degoos.wetsponge.util.reflection.ReflectionUtils;
import java.lang.reflect.InvocationTargetException;

public class SpigotNBTTagLong
extends SpigotNBTBase
implements WSNBTTagLong {
    private static final Class<?> clazz = NMSUtils.getNMSClass("NBTTagLong");

    public SpigotNBTTagLong(long k) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        this(clazz.getConstructor(Long.TYPE).newInstance(k));
    }

    public SpigotNBTTagLong(Object object) {
        super(object);
    }

    private long getValue() {
        try {
            return ReflectionUtils.getFirstObject(clazz, Long.TYPE, this.getHandled());
        }
        catch (Exception e) {
            InternalLogger.printException((Throwable)e, "An error has occurred while WetSponge was getting the value of a NBTTag!");
            return 0L;
        }
    }

    @Override
    public long getLong() {
        return this.getValue();
    }

    @Override
    public int getInt() {
        return (int)(this.getValue() & 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public short getShort() {
        return (short)(this.getValue() & 0xFFFFL);
    }

    @Override
    public byte getByte() {
        return (byte)(this.getValue() & 0xFFL);
    }

    @Override
    public double getDouble() {
        return this.getValue();
    }

    @Override
    public float getFloat() {
        return this.getValue();
    }

    @Override
    public WSNBTTagLong copy() {
        try {
            return new SpigotNBTTagLong(this.getValue());
        }
        catch (Exception e) {
            InternalLogger.printException((Throwable)e, "An error has occurred while WetSponge was copying a NBTTag!");
            return null;
        }
    }

    @Override
    public Object getHandled() {
        return super.getHandled();
    }
}

