/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.nbt;

import com.degoos.wetsponge.nbt.SpigotNBTBase;
import com.degoos.wetsponge.nbt.WSNBTTagFloat;
import com.degoos.wetsponge.util.InternalLogger;
import com.degoos.wetsponge.util.MathHelper;
import com.degoos.wetsponge.util.reflection.NMSUtils;
import com.degoos.wetsponge.util.reflection.ReflectionUtils;
import java.lang.reflect.InvocationTargetException;

public class SpigotNBTTagFloat
extends SpigotNBTBase
implements WSNBTTagFloat {
    private static final Class<?> clazz = NMSUtils.getNMSClass("NBTTagFloat");

    public SpigotNBTTagFloat(float f) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        this(clazz.getConstructor(Float.TYPE).newInstance(Float.valueOf(f)));
    }

    public SpigotNBTTagFloat(Object object) {
        super(object);
    }

    private float getValue() {
        try {
            return ReflectionUtils.getFirstObject(clazz, Float.TYPE, this.getHandled()).floatValue();
        }
        catch (Exception e) {
            InternalLogger.printException((Throwable)e, "An error has occurred while WetSponge was getting the value of a NBTTag!");
            return 0.0f;
        }
    }

    @Override
    public long getLong() {
        return (long)this.getValue();
    }

    @Override
    public int getInt() {
        return MathHelper.floor(this.getValue());
    }

    @Override
    public short getShort() {
        return (short)MathHelper.floor(this.getValue());
    }

    @Override
    public byte getByte() {
        return (byte)(MathHelper.floor(this.getValue()) & 0xFF);
    }

    @Override
    public double getDouble() {
        return this.getValue();
    }

    @Override
    public float getFloat() {
        return this.getValue();
    }

    @Override
    public WSNBTTagFloat copy() {
        try {
            return new SpigotNBTTagFloat(this.getValue());
        }
        catch (Exception e) {
            InternalLogger.printException((Throwable)e, "An error has occurred while WetSponge was copying a NBTTag!");
            return null;
        }
    }

    @Override
    public Object getHandled() {
        return super.getHandled();
    }
}

