/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.nbt;

import com.degoos.wetsponge.nbt.SpigotNBTBase;
import com.degoos.wetsponge.nbt.WSNBTTagDouble;
import com.degoos.wetsponge.util.InternalLogger;
import com.degoos.wetsponge.util.MathHelper;
import com.degoos.wetsponge.util.reflection.NMSUtils;
import com.degoos.wetsponge.util.reflection.ReflectionUtils;
import java.lang.reflect.InvocationTargetException;

public class SpigotNBTTagDouble
extends SpigotNBTBase
implements WSNBTTagDouble {
    private static final Class<?> clazz = NMSUtils.getNMSClass("NBTTagDouble");

    public SpigotNBTTagDouble(double d) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        this(clazz.getConstructor(Double.TYPE).newInstance(d));
    }

    public SpigotNBTTagDouble(Object object) {
        super(object);
    }

    private double getValue() {
        try {
            return ReflectionUtils.getFirstObject(clazz, Double.TYPE, this.getHandled());
        }
        catch (Exception e) {
            InternalLogger.printException((Throwable)e, "An error has occurred while WetSponge was getting the value of a NBTTag!");
            return 0.0;
        }
    }

    @Override
    public long getLong() {
        return (long)this.getValue();
    }

    @Override
    public int getInt() {
        return MathHelper.floor(this.getValue());
    }

    @Override
    public short getShort() {
        return (short)MathHelper.floor(this.getValue());
    }

    @Override
    public byte getByte() {
        return (byte)(MathHelper.floor(this.getValue()) & 0xFF);
    }

    @Override
    public double getDouble() {
        return this.getValue();
    }

    @Override
    public float getFloat() {
        return (float)this.getValue();
    }

    @Override
    public WSNBTTagDouble copy() {
        try {
            return new SpigotNBTTagDouble(this.getValue());
        }
        catch (Exception e) {
            InternalLogger.printException((Throwable)e, "An error has occurred while WetSponge was copying a NBTTag!");
            return null;
        }
    }

    @Override
    public Object getHandled() {
        return super.getHandled();
    }
}

