/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.nbt;

import com.degoos.wetsponge.WetSponge;
import com.degoos.wetsponge.enums.EnumServerVersion;
import com.degoos.wetsponge.nbt.Spigot13NBTBase;
import com.degoos.wetsponge.nbt.Spigot13NBTTagCompound;
import com.degoos.wetsponge.nbt.Spigot13NBTTagEnd;
import com.degoos.wetsponge.nbt.Spigot13NBTTagParser;
import com.degoos.wetsponge.nbt.WSNBTBase;
import com.degoos.wetsponge.nbt.WSNBTTagCompound;
import com.degoos.wetsponge.nbt.WSNBTTagDouble;
import com.degoos.wetsponge.nbt.WSNBTTagFloat;
import com.degoos.wetsponge.nbt.WSNBTTagInt;
import com.degoos.wetsponge.nbt.WSNBTTagIntArray;
import com.degoos.wetsponge.nbt.WSNBTTagList;
import com.degoos.wetsponge.nbt.WSNBTTagString;
import com.degoos.wetsponge.util.InternalLogger;
import com.degoos.wetsponge.util.reflection.NMSUtils;
import com.degoos.wetsponge.util.reflection.ReflectionUtils;
import java.util.ArrayList;
import java.util.List;

public class Spigot13NBTTagList
extends Spigot13NBTBase
implements WSNBTTagList {
    private static final Class<?> clazz = NMSUtils.getNMSClass("NBTTagList");
    private List list;

    public Spigot13NBTTagList() throws IllegalAccessException, InstantiationException {
        this(clazz.newInstance());
        try {
            this.list = ReflectionUtils.getFirstObject(clazz, List.class, this.getHandled());
        }
        catch (Exception e) {
            InternalLogger.printException((Throwable)e, "An error has occurred while WetSponge vas initializing a NBTTagList!");
            this.list = new ArrayList();
        }
    }

    public Spigot13NBTTagList(Object object) {
        super(object);
    }

    @Override
    public void appendTag(WSNBTBase wsnbt) {
        try {
            ReflectionUtils.invokeMethod(this.getHandled(), "add", wsnbt.getHandled());
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was modifying a NBTTagList!");
        }
    }

    @Override
    public void set(int index, WSNBTBase wsnbt) {
        try {
            ReflectionUtils.invokeMethod(this.getHandled(), "a", index, wsnbt.getHandled());
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was modifying a NBTTagList!");
        }
    }

    @Override
    public void removeTag(int index) {
        try {
            ReflectionUtils.invokeMethod(this.getHandled(), WetSponge.getVersion().isNewerThan(EnumServerVersion.MINECRAFT_OLD) ? "remove" : "a", index);
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was modifying a NBTTagList!");
        }
    }

    @Override
    public WSNBTTagCompound getCompoundTagAt(int index) {
        try {
            return new Spigot13NBTTagCompound(ReflectionUtils.invokeMethod(this.getHandled(), "get", index));
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was getting a NBTTagCompound from a NBTTagList!");
            try {
                return new Spigot13NBTTagCompound();
            }
            catch (Exception e) {
                InternalLogger.printException((Throwable)ex, "An error has occurred while WetSponge was creating a new NBTTagCompound!");
                return null;
            }
        }
    }

    @Override
    public int getIntAt(int index) {
        WSNBTBase tag;
        if (index >= 0 && index < this.list.size() && (tag = this.get(index)).getId() == 3) {
            return ((WSNBTTagInt)tag).getInt();
        }
        return 0;
    }

    @Override
    public int[] getIntArrayAt(int index) {
        WSNBTBase tag;
        if (index >= 0 && index < this.list.size() && (tag = this.get(index)).getId() == 11) {
            return ((WSNBTTagIntArray)tag).getIntArray();
        }
        return new int[0];
    }

    @Override
    public double getDoubleAt(int index) {
        WSNBTBase tag;
        if (index >= 0 && index < this.list.size() && (tag = this.get(index)).getId() == 6) {
            return ((WSNBTTagDouble)tag).getDouble();
        }
        return 0.0;
    }

    @Override
    public float getFloatAt(int index) {
        WSNBTBase tag;
        if (index >= 0 && index < this.list.size() && (tag = this.get(index)).getId() == 5) {
            return ((WSNBTTagFloat)tag).getFloat();
        }
        return 0.0f;
    }

    @Override
    public String getStringAt(int index) {
        if (index >= 0 && index < this.list.size()) {
            WSNBTBase tag = this.get(index);
            return tag.getId() == 8 ? ((WSNBTTagString)tag).getString() : tag.toString();
        }
        return "";
    }

    @Override
    public WSNBTBase get(int index) {
        return index >= 0 && index < this.list.size() ? Spigot13NBTTagParser.parse(this.list.get(index)) : new Spigot13NBTTagEnd();
    }

    @Override
    public int tagCount() {
        return this.list.size();
    }

    @Override
    public int getTagType() {
        try {
            return ((Byte)ReflectionUtils.setAccessible(clazz.getDeclaredField("item")).get(this.getHandled())).byteValue();
        }
        catch (Exception e) {
            InternalLogger.printException((Throwable)e, "An error has occurred while WetSponge was getting the type of a NBTTagList!");
            return 0;
        }
    }

    @Override
    public WSNBTTagList copy() {
        try {
            Spigot13NBTTagList list = new Spigot13NBTTagList();
            for (Object o : list.list) {
                WSNBTBase base = Spigot13NBTTagParser.parse(o);
                list.appendTag(base);
            }
            return list;
        }
        catch (Exception ex) {
            InternalLogger.printException((Throwable)ex, "An error has occurred while Wetsponge was copying a NBTTagList!");
            return null;
        }
    }
}

