/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.item.type;

import com.degoos.wetsponge.color.WSColor;
import com.degoos.wetsponge.firework.WSFireworkEffect;
import com.degoos.wetsponge.material.item.WSItemType;
import com.degoos.wetsponge.nbt.WSNBTTagCompound;
import com.degoos.wetsponge.nbt.WSNBTTagInt;
import com.degoos.wetsponge.nbt.WSNBTTagList;
import java.util.ArrayList;
import java.util.Optional;

public interface WSItemTypeFireworkCharge
extends WSItemType {
    public Optional<WSFireworkEffect> getEffect();

    public void setEffect(WSFireworkEffect var1);

    @Override
    public WSItemTypeFireworkCharge clone();

    @Override
    default public WSNBTTagCompound writeToData(WSNBTTagCompound compound) {
        WSFireworkEffect fireworkEffect = this.getEffect().orElse(null);
        if (fireworkEffect == null) {
            return compound;
        }
        WSNBTTagCompound fireworkCompound = WSNBTTagCompound.of();
        fireworkCompound.setString("shape", fireworkEffect.getShape().name());
        fireworkCompound.setBoolean("flickers", fireworkEffect.flickers());
        fireworkCompound.setBoolean("trail", fireworkEffect.hasTrail());
        WSNBTTagList colors = WSNBTTagList.of();
        fireworkEffect.getColors().forEach(target -> colors.appendTag(WSNBTTagInt.of(target.toRGB())));
        fireworkCompound.setTag("colors", colors);
        WSNBTTagList fadeColors = WSNBTTagList.of();
        fireworkEffect.getFadeColors().forEach(target -> fadeColors.appendTag(WSNBTTagInt.of(target.toRGB())));
        fireworkCompound.setTag("fadeColors", fadeColors);
        compound.setTag("effect", fireworkCompound);
        return compound;
    }

    @Override
    default public WSNBTTagCompound readFromData(WSNBTTagCompound compound) {
        if (!compound.hasKey("effect")) {
            this.setEffect(null);
            return compound;
        }
        WSNBTTagCompound firework = (WSNBTTagCompound)compound.getTag("effect");
        boolean flickers = firework.getBoolean("flickers");
        boolean trail = firework.getBoolean("trail");
        ArrayList<WSColor> colors = new ArrayList<WSColor>();
        WSNBTTagList colorTag = (WSNBTTagList)firework.getTag("colors");
        for (int c = 0; c < colorTag.tagCount(); ++c) {
            colors.add(WSColor.ofRGB(colorTag.getIntAt(c)));
        }
        ArrayList<WSColor> fadeColors = new ArrayList<WSColor>();
        WSNBTTagList fadeColorTag = (WSNBTTagList)firework.getTag("fadeColors");
        for (int c = 0; c < fadeColorTag.tagCount(); ++c) {
            fadeColors.add(WSColor.ofRGB(fadeColorTag.getIntAt(c)));
        }
        this.setEffect(WSFireworkEffect.builder().flicker(flickers).trail(trail).colors(colors).fades(fadeColors).build());
        return compound;
    }
}

