/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.item.type;

import com.degoos.wetsponge.enums.item.EnumItemTypeBookGeneration;
import com.degoos.wetsponge.material.item.SpongeItemType;
import com.degoos.wetsponge.material.item.type.WSItemTypeWrittenBook;
import com.degoos.wetsponge.text.SpongeText;
import com.degoos.wetsponge.text.WSText;
import com.degoos.wetsponge.util.Validate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.text.Text;

public class SpongeItemTypeWrittenBook
extends SpongeItemType
implements WSItemTypeWrittenBook {
    private WSText title;
    private WSText author;
    private List<WSText> pages;
    private EnumItemTypeBookGeneration generation;

    public SpongeItemTypeWrittenBook(int id, String stringId, String stringId13, WSText title, WSText author, List<WSText> pages, EnumItemTypeBookGeneration generation) {
        super(id, stringId, stringId13, 1);
        Validate.notNull((Object)generation, "Generation cannot be null!");
        this.title = title;
        this.author = author;
        this.pages = pages == null ? new ArrayList() : pages;
        this.generation = generation;
    }

    @Override
    public WSText getAuthor() {
        return this.author;
    }

    @Override
    public WSItemTypeWrittenBook setAuthor(WSText author) {
        this.author = author;
        return this;
    }

    @Override
    public WSText getTitle() {
        return this.title;
    }

    @Override
    public WSItemTypeWrittenBook setTitle(WSText title) {
        this.title = title;
        return this;
    }

    @Override
    public List<WSText> getPages() {
        return this.pages;
    }

    @Override
    public WSItemTypeWrittenBook addPage(WSText pageText) {
        this.pages.add(pageText);
        return this;
    }

    @Override
    public WSItemTypeWrittenBook setPages(List<WSText> pages) {
        this.pages = pages;
        return this;
    }

    @Override
    public EnumItemTypeBookGeneration getGeneration() {
        return this.generation;
    }

    @Override
    public void setGeneration(EnumItemTypeBookGeneration generation) {
        Validate.notNull((Object)generation, "Generation cannot be null!");
        this.generation = generation;
    }

    @Override
    public SpongeItemTypeWrittenBook clone() {
        return new SpongeItemTypeWrittenBook(this.getNumericalId(), this.getStringId(), this.getStringId(), this.title, this.author, new ArrayList<WSText>(this.pages), this.generation);
    }

    @Override
    public ItemStack writeItemStack(ItemStack itemStack) {
        super.writeItemStack(itemStack);
        itemStack.offer(Keys.BOOK_AUTHOR, (Object)((Text)this.author.getHandled()));
        itemStack.offer(Keys.BOOK_PAGES, this.pages.stream().map(text -> (Text)text.getHandled()).collect(Collectors.toList()));
        itemStack.offer(Keys.DISPLAY_NAME, (Object)((Text)this.title.getHandled()));
        itemStack.offer(Keys.GENERATION, (Object)this.generation.getValue());
        return itemStack;
    }

    @Override
    public SpongeItemTypeWrittenBook readContainer(ValueContainer<?> valueContainer) {
        super.readContainer((ValueContainer)valueContainer);
        this.author = valueContainer.get(Keys.BOOK_AUTHOR).map(SpongeText::of).orElse((SpongeText)WSText.empty());
        this.pages = ((List)valueContainer.get(Keys.BOOK_PAGES).orElse(new ArrayList())).stream().map(SpongeText::of).collect(Collectors.toList());
        this.title = valueContainer.get(Keys.DISPLAY_NAME).map(SpongeText::of).orElse((SpongeText)WSText.empty());
        this.generation = EnumItemTypeBookGeneration.getByValue(valueContainer.get(Keys.GENERATION).orElse(0)).orElse(EnumItemTypeBookGeneration.ORIGINAL);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeItemTypeWrittenBook that = (SpongeItemTypeWrittenBook)o;
        return Objects.equals(this.title, that.title) && Objects.equals(this.author, that.author) && Objects.equals(this.pages, that.pages) && this.generation == that.generation;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.title, this.author, this.pages, this.generation});
    }
}

