/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.item.type;

import com.degoos.wetsponge.bridge.material.item.BridgeItemTypeSkull;
import com.degoos.wetsponge.enums.block.EnumBlockTypeSkullType;
import com.degoos.wetsponge.material.item.SpongeItemType;
import com.degoos.wetsponge.material.item.type.WSItemTypeSkull;
import com.degoos.wetsponge.user.SpongeGameProfile;
import com.degoos.wetsponge.user.WSGameProfile;
import com.degoos.wetsponge.util.Validate;
import java.net.URL;
import java.util.Objects;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.SkullType;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.profile.GameProfile;

public class SpongeItemTypeSkull
extends SpongeItemType
implements WSItemTypeSkull {
    private WSGameProfile profile;
    private EnumBlockTypeSkullType skullType;

    public SpongeItemTypeSkull(WSGameProfile profile, EnumBlockTypeSkullType skullType) {
        super(397, "minecraft:skull", "minecraft:skull", 64);
        Validate.notNull((Object)skullType, "Skull type cannot be null!");
        this.profile = profile;
        this.skullType = skullType;
    }

    @Override
    public String getNewStringId() {
        return this.skullType.getMinecraftName() + (this.skullType == EnumBlockTypeSkullType.SKELETON || this.skullType == EnumBlockTypeSkullType.WITHER_SKELETON ? "_skull" : "_head");
    }

    @Override
    public Optional<WSGameProfile> getProfile() {
        return Optional.ofNullable(this.profile);
    }

    @Override
    public void setProfile(WSGameProfile profile) {
        this.profile = profile;
    }

    @Override
    public void setTexture(String texture) {
        BridgeItemTypeSkull.setTexture(texture, this.profile);
    }

    @Override
    public void setTexture(URL texture) {
        BridgeItemTypeSkull.setTexture(texture, this.profile);
    }

    @Override
    public void setTextureByPlayerName(String name) {
        this.profile = BridgeItemTypeSkull.setTextureByPlayerName(name);
    }

    @Override
    public void findFormatAndSetTexture(String texture) {
        if (texture.toLowerCase().startsWith("http:") || texture.toLowerCase().startsWith("https:")) {
            this.setTexture(this.getTexture(texture));
        } else if (texture.length() <= 16) {
            this.setTextureByPlayerName(texture);
        } else {
            this.setTexture(texture);
        }
    }

    @Override
    public EnumBlockTypeSkullType getSkullType() {
        return this.skullType;
    }

    @Override
    public void setSkullType(EnumBlockTypeSkullType skullType) {
        Validate.notNull((Object)skullType, "Skull type cannot be null!");
        this.skullType = skullType;
    }

    private String getTexture(String url) {
        if (url == null) {
            return null;
        }
        return String.format("{textures:{SKIN:{url:\"%s\"}}}", url);
    }

    @Override
    public SpongeItemTypeSkull clone() {
        return new SpongeItemTypeSkull(this.profile, this.skullType);
    }

    @Override
    public ItemStack writeItemStack(ItemStack itemStack) {
        super.writeItemStack(itemStack);
        itemStack.offer(Keys.SKULL_TYPE, Sponge.getRegistry().getType(SkullType.class, this.skullType.getSpongeName()).orElseThrow(NullPointerException::new));
        itemStack.offer(Keys.REPRESENTED_PLAYER, this.profile == null ? null : ((SpongeGameProfile)this.profile).getHandled());
        return itemStack;
    }

    @Override
    public SpongeItemTypeSkull readContainer(ValueContainer<?> valueContainer) {
        super.readContainer((ValueContainer)valueContainer);
        this.skullType = EnumBlockTypeSkullType.getBySpongeName(((SkullType)valueContainer.get(Keys.SKULL_TYPE).orElseThrow(NullPointerException::new)).getName()).orElse(EnumBlockTypeSkullType.SKELETON);
        GameProfile profile = valueContainer.get(Keys.REPRESENTED_PLAYER).orElse(null);
        this.profile = profile == null ? null : new SpongeGameProfile(profile);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeItemTypeSkull that = (SpongeItemTypeSkull)o;
        return Objects.equals(this.profile, that.profile) && this.skullType == that.skullType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.profile, this.skullType});
    }
}

