/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.item.type;

import com.degoos.wetsponge.enums.item.EnumItemTypeFishType;
import com.degoos.wetsponge.material.item.SpongeItemType;
import com.degoos.wetsponge.material.item.type.WSItemTypeFish;
import com.degoos.wetsponge.util.Validate;
import java.util.Objects;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.Fish;
import org.spongepowered.api.data.type.Fishes;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.item.inventory.ItemStack;

public class SpongeItemTypeFish
extends SpongeItemType
implements WSItemTypeFish {
    private EnumItemTypeFishType fishType;

    public SpongeItemTypeFish(EnumItemTypeFishType fishType) {
        super(263, "minecraft:fish", "minecraft:cod", 64);
        Validate.notNull((Object)fishType, "Fish type cannot be null!");
        this.fishType = fishType;
    }

    @Override
    public String getNewStringId() {
        switch (this.fishType) {
            case SALMON: {
                return "minecraft:salmon";
            }
            case TROPICAL_FISH: {
                return "minecraft:tropical_fish";
            }
            case PUFFERFISH: {
                return "minecraft:pufferfish";
            }
        }
        return "minecraft:cod";
    }

    @Override
    public EnumItemTypeFishType getFishType() {
        return this.fishType;
    }

    @Override
    public void setFishType(EnumItemTypeFishType fishType) {
        Validate.notNull((Object)fishType, "Fish type cannot be null!");
        this.fishType = fishType;
    }

    @Override
    public SpongeItemTypeFish clone() {
        return new SpongeItemTypeFish(this.fishType);
    }

    @Override
    public ItemStack writeItemStack(ItemStack itemStack) {
        super.writeItemStack(itemStack);
        itemStack.offer(Keys.FISH_TYPE, (Object)Sponge.getRegistry().getType(Fish.class, this.fishType.getSpongeName()).orElse(Fishes.COD));
        return itemStack;
    }

    @Override
    public SpongeItemTypeFish readContainer(ValueContainer<?> valueContainer) {
        super.readContainer((ValueContainer)valueContainer);
        this.fishType = EnumItemTypeFishType.getBySpongeName(valueContainer.get(Keys.FISH_TYPE).orElse(Fishes.COD).getName()).orElse(EnumItemTypeFishType.COD);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeItemTypeFish that = (SpongeItemTypeFish)o;
        return this.fishType == that.fishType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.fishType});
    }
}

