/*
 * Decompiled with CFR 0.152.
 */
package com.degoos.wetsponge.material.item.type;

import com.degoos.wetsponge.block.tileentity.extra.WSBannerPattern;
import com.degoos.wetsponge.enums.EnumDyeColor;
import com.degoos.wetsponge.enums.block.EnumBannerPatternShape;
import com.degoos.wetsponge.material.item.type.SpongeItemTypeDyeColored;
import com.degoos.wetsponge.material.item.type.WSItemTypeBanner;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.item.inventory.ItemStack;

public class SpongeItemTypeBanner
extends SpongeItemTypeDyeColored
implements WSItemTypeBanner {
    private List<WSBannerPattern> patterns;

    public SpongeItemTypeBanner(EnumDyeColor dyeColor, List<WSBannerPattern> patterns) {
        super(425, "minecraft:banner", "banner", 64, dyeColor);
        this.patterns = patterns == null ? new ArrayList<WSBannerPattern>() : patterns.stream().map(WSBannerPattern::clone).collect(Collectors.toList());
    }

    @Override
    public List<WSBannerPattern> getPatterns() {
        return this.patterns;
    }

    @Override
    public void setPatterns(List<WSBannerPattern> patterns) {
        this.patterns = patterns == null ? new ArrayList() : patterns;
    }

    @Override
    public SpongeItemTypeBanner clone() {
        return new SpongeItemTypeBanner(this.getDyeColor(), this.patterns);
    }

    @Override
    public ItemStack writeItemStack(ItemStack itemStack) {
        super.writeItemStack(itemStack);
        NBTTagCompound compound = ((net.minecraft.item.ItemStack)itemStack).func_77978_p();
        if (compound == null) {
            compound = new NBTTagCompound();
        }
        NBTTagCompound banner = new NBTTagCompound();
        banner.func_74768_a("Base", (int)this.getDyeColor().getDyeData());
        NBTTagList patterns = new NBTTagList();
        this.patterns.forEach(pattern -> {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("Color", (int)pattern.getColor().getDyeData());
            tag.func_74778_a("Pattern", pattern.getShape().getCode());
            patterns.func_74742_a((NBTBase)tag);
        });
        banner.func_74782_a("Patterns", (NBTBase)patterns);
        compound.func_74782_a("BlockEntityTag", (NBTBase)banner);
        ((net.minecraft.item.ItemStack)itemStack).func_77982_d(compound);
        return itemStack;
    }

    @Override
    public SpongeItemTypeBanner readContainer(ValueContainer<?> valueContainer) {
        super.readContainer((ValueContainer)valueContainer);
        this.patterns.clear();
        NBTTagCompound compound = ((net.minecraft.item.ItemStack)valueContainer).func_77978_p();
        if (compound == null) {
            return this;
        }
        NBTBase base = compound.func_74781_a("BlockEntityTag");
        if (!(base instanceof NBTTagCompound)) {
            return this;
        }
        NBTBase patterns = ((NBTTagCompound)base).func_74781_a("Patterns");
        if (!(patterns instanceof NBTTagList)) {
            return this;
        }
        for (int i = 0; i < ((NBTTagList)patterns).func_74745_c(); ++i) {
            NBTBase pattern = ((NBTTagList)patterns).func_179238_g(i);
            if (!(pattern instanceof NBTTagCompound)) {
                return this;
            }
            Optional<EnumBannerPatternShape> optional = EnumBannerPatternShape.getByCode(((NBTTagCompound)pattern).func_74779_i("Pattern"));
            if (!optional.isPresent()) continue;
            this.patterns.add(new WSBannerPattern(optional.get(), EnumDyeColor.getByDyeData((byte)((NBTTagCompound)pattern).func_74762_e("Color")).orElse(EnumDyeColor.BLACK)));
        }
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeItemTypeBanner that = (SpongeItemTypeBanner)o;
        return Objects.equals(this.patterns, that.patterns);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.patterns);
    }
}

